/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.Verify;
import io.atomix.storage.journal.FileReader;
import io.atomix.storage.journal.JournalSegmentFile;
import io.atomix.storage.journal.StorageException;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

final class DiskFileReader
extends FileReader {
    private final FileChannel channel;
    private ByteBuf buffer;
    private int bufferPosition;

    DiskFileReader(JournalSegmentFile file, ByteBuf buffer) {
        super(file);
        this.buffer = Objects.requireNonNull(buffer);
        this.channel = file.channel();
        this.bufferPosition = 0;
    }

    @Override
    void invalidateCache() {
        this.buffer.clear();
        this.bufferPosition = 0;
    }

    @Override
    ByteBuf read(int position, int size) {
        int seek = this.bufferPosition - position;
        return seek >= 0 ? this.forwardAndRead(seek, position, size) : this.rewindAndRead(-seek, position, size);
    }

    @Override
    void release() {
        ByteBuf local = this.buffer;
        if (local != null) {
            this.buffer = null;
            local.release();
        }
    }

    private @NonNull ByteBuf forwardAndRead(int seek, int position, int size) {
        int remaining = this.buffer.writerIndex() - seek;
        int missing = remaining - size;
        if (missing <= 0) {
            return this.buffer.slice(seek, size).asReadOnly();
        }
        this.buffer.writeBytes(this.buffer, seek, remaining);
        this.readAtLeast(position + seek, missing);
        return this.setAndSlice(position, size);
    }

    private @NonNull ByteBuf rewindAndRead(int rewindBy, int position, int size) {
        this.buffer.clear();
        this.readAtLeast(position, size);
        return this.setAndSlice(position, size);
    }

    private void readAtLeast(int readPosition, int readAtLeast) {
        int bytesRead;
        try {
            bytesRead = this.buffer.writeBytes(this.channel, (long)readPosition, readAtLeast);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        Verify.verify((bytesRead >= readAtLeast ? 1 : 0) != 0, (String)"Short read %s, expected %s", (int)bytesRead, (int)readAtLeast);
    }

    private @NonNull ByteBuf setAndSlice(int position, int size) {
        this.bufferPosition = position;
        return this.buffer.slice(0, size).asReadOnly();
    }
}

