/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.MoreObjects;
import io.atomix.storage.journal.DiskFileWriter;
import io.atomix.storage.journal.FileReader;
import io.atomix.storage.journal.JournalSegmentFile;
import io.atomix.storage.journal.MappedFileWriter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Objects;

abstract sealed class FileWriter
permits DiskFileWriter, MappedFileWriter {
    private final JournalSegmentFile file;
    private final int maxEntrySize;

    FileWriter(JournalSegmentFile file, int maxEntrySize) {
        this.file = Objects.requireNonNull(file);
        this.maxEntrySize = maxEntrySize;
    }

    final JournalSegmentFile file() {
        return this.file;
    }

    final int maxEntrySize() {
        return this.maxEntrySize;
    }

    abstract FileReader reader();

    abstract void writeEmptyHeader(int var1);

    abstract ByteBuf startWrite(int var1, int var2);

    abstract void commitWrite(int var1, ByteBuf var2);

    abstract void flush() throws IOException;

    abstract void release();

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.file.path()).toString();
    }
}

