/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public record JournalSegmentDescriptor(int version, long id, long index, int maxSegmentSize, int maxEntries, long updated, boolean locked) {
    public static final int BYTES = 64;
    @VisibleForTesting
    static final int VERSION = 1;

    public static @NonNull JournalSegmentDescriptor readFrom(ReadableByteChannel channel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        int read = channel.read(buffer);
        if (read != 64) {
            throw new IOException("Need 64 bytes, only " + read + " available");
        }
        buffer.flip();
        return new JournalSegmentDescriptor(buffer.getInt(), buffer.getLong(), buffer.getLong(), buffer.getInt(), buffer.getInt(), buffer.getLong(), buffer.get() == 1);
    }

    byte @NonNull [] toArray() {
        byte[] bytes = new byte[64];
        ByteBuffer.wrap(bytes).putInt(this.version).putLong(this.id).putLong(this.index).putInt(this.maxSegmentSize).putInt(this.maxEntries).putLong(this.updated).put(this.locked ? (byte)1 : 0);
        return bytes;
    }

    public static Builder builder() {
        return JournalSegmentDescriptor.builder(1);
    }

    public static Builder builder(int version) {
        return new Builder(version);
    }

    public static final class Builder {
        private final int version;
        private Long id;
        private Long index;
        private Integer maxSegmentSize;
        private Integer maxEntries;
        private Long updated;

        Builder(int version) {
            this.version = version;
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withIndex(long index) {
            this.index = index;
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            this.maxSegmentSize = maxSegmentSize;
            return this;
        }

        @Deprecated
        public Builder withMaxEntries(int maxEntries) {
            this.maxEntries = maxEntries;
            return this;
        }

        public Builder withUpdated(long updated) {
            this.updated = updated;
            return this;
        }

        public JournalSegmentDescriptor build() {
            return new JournalSegmentDescriptor(this.version, Builder.checkSet(this.id, "id"), Builder.checkSet(this.index, "index"), Builder.checkSet(this.maxSegmentSize, "maxSegmentSize"), Builder.checkSet(this.maxEntries, "maxEntries"), Builder.checkSet(this.updated, "updated"), false);
        }

        private static <T> @NonNull T checkSet(@Nullable T obj, String name) {
            if (obj != null) {
                return obj;
            }
            throw new IllegalArgumentException(name + " not set");
        }
    }
}

