/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.esotericsoftware.kryo.KryoException;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import io.atomix.utils.serializer.KryoJournalSerdesBuilder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.opendaylight.controller.raft.journal.FromByteBufMapper;
import org.opendaylight.controller.raft.journal.ToByteBufMapper;

@Deprecated(forRemoval=true, since="9.0.3")
public interface JournalSerdes {
    public byte[] serialize(Object var1);

    public byte[] serialize(Object var1, int var2);

    public void serialize(Object var1, ByteBuffer var2);

    public void serialize(Object var1, OutputStream var2);

    public void serialize(Object var1, OutputStream var2, int var3);

    public <T> T deserialize(byte[] var1);

    public <T> T deserialize(ByteBuffer var1);

    public <T> T deserialize(InputStream var1);

    public <T> T deserialize(InputStream var1, int var2);

    default public <T> FromByteBufMapper<T> toReadMapper() {
        return (index, bytes) -> this.deserialize(bytes.nioBuffer());
    }

    default public <T> ToByteBufMapper<T> toWriteMapper() {
        return (obj, buf) -> {
            ByteBuffer nio = buf.nioBuffer();
            try {
                this.serialize(obj, nio);
            }
            catch (KryoException e) {
                throw JournalSerdes.newIOException(e);
            }
            finally {
                buf.writerIndex(buf.readerIndex() + nio.position());
            }
        };
    }

    private static IOException newIOException(KryoException cause) {
        KryoException rootKryo = cause;
        for (Throwable nextCause = rootKryo.getCause(); nextCause != null; nextCause = nextCause.getCause()) {
            KryoException kryo;
            if (!(nextCause instanceof KryoException)) continue;
            rootKryo = kryo = (KryoException)nextCause;
        }
        if (rootKryo.getMessage().startsWith("Buffer overflow.")) {
            EOFException ex = new EOFException();
            ex.initCause(cause);
            return ex;
        }
        return new IOException(rootKryo);
    }

    public static Builder builder() {
        return new KryoJournalSerdesBuilder();
    }

    public static interface EntrySerdes<T> {
        public T read(EntryInput var1) throws IOException;

        public void write(EntryOutput var1, T var2) throws IOException;
    }

    @Beta
    public static interface EntryOutput {
        public void writeBytes(byte[] var1) throws IOException;

        public void writeLong(long var1) throws IOException;

        public void writeObject(Object var1) throws IOException;

        public void writeString(String var1) throws IOException;

        @VisibleForTesting
        public void writeVarInt(int var1) throws IOException;
    }

    @Beta
    public static interface EntryInput {
        public byte[] readBytes(int var1) throws IOException;

        public long readLong() throws IOException;

        public String readString() throws IOException;

        public Object readObject() throws IOException;

        @VisibleForTesting
        public int readVarInt() throws IOException;
    }

    public static interface Builder {
        public JournalSerdes build();

        public JournalSerdes build(String var1);

        public Builder register(EntrySerdes<?> var1, Class<?> ... var2);

        public Builder setClassLoader(ClassLoader var1);
    }
}

