/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.JournalSegmentFile;
import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;

final class MappedByteBuf
extends AbstractReferenceCountedByteBuf
implements Flushable {
    private final ByteBufAllocator alloc;
    private MappedByteBuffer byteBuffer;
    private ByteBuffer internalNio;

    private MappedByteBuf(ByteBufAllocator alloc, MappedByteBuffer byteBuffer) {
        super(byteBuffer.limit());
        this.alloc = Objects.requireNonNull(alloc);
        this.byteBuffer = Objects.requireNonNull(byteBuffer);
    }

    @NonNullByDefault
    static MappedByteBuf of(JournalSegmentFile file) throws IOException {
        return new MappedByteBuf(file.allocator(), file.channel().map(FileChannel.MapMode.READ_WRITE, 0L, file.maxSize()));
    }

    @Override
    public void flush() throws IOException {
        this.ensureAccessible();
        try {
            this.byteBuffer.force();
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    protected void deallocate() {
        MappedByteBuffer local = this.byteBuffer;
        if (local != null) {
            this.byteBuffer = null;
            PlatformDependent.freeDirectBuffer((ByteBuffer)local);
        }
    }

    public ByteBufAllocator alloc() {
        return this.alloc;
    }

    public boolean isContiguous() {
        return true;
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    public int capacity() {
        return this.maxCapacity();
    }

    public ByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException("capacity cannot be set");
    }

    @Deprecated
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public ByteBuf unwrap() {
        return null;
    }

    public ByteBuf copy(int index, int length) {
        this.ensureAccessible();
        return this.alloc.heapBuffer(length).writeBytes((ByteBuffer)this.byteBuffer.slice(index, length));
    }

    public boolean isDirect() {
        return true;
    }

    public int nioBufferCount() {
        return 1;
    }

    public ByteBuffer nioBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.byteBuffer.slice(index, length);
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        this.checkIndex(index, length);
        return this.internalNio().position(index).limit(index + length);
    }

    private ByteBuffer internalNio() {
        ByteBuffer local = this.internalNio;
        if (local == null) {
            this.internalNio = local = this.byteBuffer.duplicate();
        }
        return local;
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    public byte getByte(int index) {
        this.ensureAccessible();
        return this._getByte(index);
    }

    protected byte _getByte(int index) {
        return this.byteBuffer.get(index);
    }

    public short getShort(int index) {
        this.ensureAccessible();
        return this._getShort(index);
    }

    protected short _getShort(int index) {
        return this.byteBuffer.getShort(index);
    }

    protected short _getShortLE(int index) {
        return ByteBufUtil.swapShort((short)this.byteBuffer.getShort(index));
    }

    public int getUnsignedMedium(int index) {
        this.ensureAccessible();
        return this._getUnsignedMedium(index);
    }

    protected int _getUnsignedMedium(int index) {
        return (this._getByte(index) & 0xFF) << 16 | (this._getByte(index + 1) & 0xFF) << 8 | this._getByte(index + 2) & 0xFF;
    }

    protected int _getUnsignedMediumLE(int index) {
        return this._getByte(index) & 0xFF | (this._getByte(index + 1) & 0xFF) << 8 | (this._getByte(index + 2) & 0xFF) << 16;
    }

    public int getInt(int index) {
        this.ensureAccessible();
        return this._getInt(index);
    }

    protected int _getInt(int index) {
        return this.byteBuffer.getInt(index);
    }

    protected int _getIntLE(int index) {
        return ByteBufUtil.swapInt((int)this.byteBuffer.getInt(index));
    }

    public long getLong(int index) {
        this.ensureAccessible();
        return this._getLong(index);
    }

    protected long _getLong(int index) {
        return this.byteBuffer.getLong(index);
    }

    protected long _getLongLE(int index) {
        return ByteBufUtil.swapLong((long)this.byteBuffer.getLong(index));
    }

    public ByteBuf setByte(int index, int value) {
        this.ensureAccessible();
        this._setByte(index, value);
        return this;
    }

    protected void _setByte(int index, int value) {
        this.byteBuffer.put(index, (byte)value);
    }

    public ByteBuf setShort(int index, int value) {
        this.ensureAccessible();
        this._setShort(index, value);
        return this;
    }

    protected void _setShort(int index, int value) {
        this.byteBuffer.putShort(index, (short)value);
    }

    protected void _setShortLE(int index, int value) {
        this.byteBuffer.putShort(index, ByteBufUtil.swapShort((short)((short)value)));
    }

    public ByteBuf setMedium(int index, int value) {
        this.ensureAccessible();
        this._setMedium(index, value);
        return this;
    }

    protected void _setMedium(int index, int value) {
        this.setByte(index, (byte)(value >>> 16));
        this.setByte(index + 1, (byte)(value >>> 8));
        this.setByte(index + 2, (byte)value);
    }

    protected void _setMediumLE(int index, int value) {
        this.setByte(index, (byte)value);
        this.setByte(index + 1, (byte)(value >>> 8));
        this.setByte(index + 2, (byte)(value >>> 16));
    }

    public ByteBuf setInt(int index, int value) {
        this.ensureAccessible();
        this._setInt(index, value);
        return this;
    }

    protected void _setInt(int index, int value) {
        this.byteBuffer.putInt(index, value);
    }

    protected void _setIntLE(int index, int value) {
        this.byteBuffer.putInt(index, ByteBufUtil.swapInt((int)value));
    }

    public ByteBuf setLong(int index, long value) {
        this.ensureAccessible();
        this._setLong(index, value);
        return this;
    }

    protected void _setLong(int index, long value) {
        this.byteBuffer.putLong(index, value);
    }

    protected void _setLongLE(int index, long value) {
        this.byteBuffer.putLong(index, ByteBufUtil.swapLong((long)value));
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (dst.hasArray()) {
            this.byteBuffer.get(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            dst.setBytes(dstIndex, (ByteBuf)this, index, length);
        }
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.length);
        this.byteBuffer.get(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        int remaining = dst.remaining();
        this.checkIndex(index, remaining);
        dst.put(this.byteBuffer.slice(index, remaining));
        return this;
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.capacity());
        src.getBytes(srcIndex, (ByteBuf)this, index, length);
        return this;
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.checkSrcIndex(index, length, srcIndex, src.length);
        this.byteBuffer.put(index, src, srcIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.ensureAccessible();
        this.byteBuffer.put(index, src, src.position(), src.remaining());
        return this;
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        throw new UnsupportedOperationException();
    }
}

