/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.FileWriter;
import io.atomix.storage.journal.JournalSegmentFile;
import io.atomix.storage.journal.MappedFileReader;
import io.netty.buffer.ByteBuf;
import java.io.Flushable;
import java.io.IOException;
import java.util.Objects;

final class MappedFileWriter
extends FileWriter {
    private final MappedFileReader reader;
    private final ByteBuf buffer;
    private final Flushable flush;

    MappedFileWriter(JournalSegmentFile file, int maxEntrySize, ByteBuf buffer, Flushable flush) {
        super(file, maxEntrySize);
        this.buffer = Objects.requireNonNull(buffer);
        this.flush = Objects.requireNonNull(flush);
        this.reader = new MappedFileReader(file, buffer);
    }

    @Override
    MappedFileReader reader() {
        return this.reader;
    }

    @Override
    void writeEmptyHeader(int position) {
        this.buffer.setLong(position, 0L);
    }

    @Override
    ByteBuf startWrite(int position, int size) {
        return this.buffer.slice(position, size);
    }

    @Override
    void commitWrite(int position, ByteBuf entry) {
    }

    @Override
    void flush() throws IOException {
        this.flush.flush();
    }

    @Override
    void release() {
    }
}

