/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.JournalSegment;
import io.atomix.storage.journal.JournalSegmentReader;
import io.atomix.storage.journal.SegmentedByteBufJournal;
import io.atomix.storage.journal.SegmentedCommitsByteBufReader;
import io.atomix.storage.journal.index.Position;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.raft.journal.EntryReader;
import org.opendaylight.controller.raft.journal.FromByteBufMapper;

sealed class SegmentedByteBufReader
implements EntryReader
permits SegmentedCommitsByteBufReader {
    final @NonNull SegmentedByteBufJournal journal;
    private JournalSegment currentSegment;
    private JournalSegmentReader currentReader;
    private long nextIndex;

    SegmentedByteBufReader(SegmentedByteBufJournal journal, JournalSegment segment) {
        this.journal = Objects.requireNonNull(journal);
        this.currentSegment = Objects.requireNonNull(segment);
        this.currentReader = segment.createReader();
        this.nextIndex = this.currentSegment.firstIndex();
    }

    public final long nextIndex() {
        return this.nextIndex;
    }

    public final void reset() {
        this.currentReader.close();
        this.currentSegment = this.journal.firstSegment();
        this.currentReader = this.currentSegment.createReader();
        this.nextIndex = this.currentSegment.firstIndex();
    }

    public final void reset(long index) {
        if (!this.currentSegment.isOpen()) {
            this.reset();
        }
        if (index < this.nextIndex) {
            this.rewind(index);
        } else if (index > this.nextIndex) {
            this.forwardTo(index);
        } else {
            this.resetCurrentReader(index);
        }
    }

    private void resetCurrentReader(long index) {
        Position position = this.currentSegment.lookup(index - 1L);
        if (position != null) {
            this.nextIndex = position.index();
            this.currentReader.setPosition(position.position());
        } else {
            this.nextIndex = this.currentSegment.firstIndex();
            this.currentReader.setPosition(64);
        }
        this.forwardTo(index);
    }

    private void rewind(long index) {
        JournalSegment segment;
        if (this.currentSegment.firstIndex() >= index && (segment = this.journal.segment(index - 1L)) != null) {
            this.currentReader.close();
            this.currentSegment = segment;
            this.currentReader = this.currentSegment.createReader();
        }
        this.resetCurrentReader(index);
    }

    private void forwardTo(long index) {
        while (this.nextIndex < index && this.tryAdvance(this.nextIndex) != null) {
        }
    }

    public final <T> T tryNext(FromByteBufMapper<T> mapper) {
        long index = this.nextIndex;
        ByteBuf bytes = this.tryAdvance(index);
        return (T)(bytes == null ? null : mapper.bytesToObject(index, bytes));
    }

    ByteBuf tryAdvance(long index) {
        ByteBuf buf = this.currentReader.readBytes();
        if (buf == null) {
            JournalSegment nextSegment = this.journal.tryNextSegment(this.currentSegment.firstIndex());
            if (nextSegment == null || nextSegment.firstIndex() != index) {
                return null;
            }
            this.currentReader.close();
            this.currentSegment = nextSegment;
            this.currentReader = this.currentSegment.createReader();
            buf = this.currentReader.readBytes();
            if (buf == null) {
                return null;
            }
        }
        this.nextIndex = index + 1L;
        return buf;
    }

    public final void close() {
        this.currentReader.close();
        this.journal.closeReader(this);
    }
}

