/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import com.google.common.base.MoreObjects;
import io.atomix.storage.journal.Journal;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.SegmentedJournalReader;
import io.atomix.storage.journal.SegmentedJournalWriter;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.raft.journal.EntryReader;
import org.opendaylight.controller.raft.journal.FromByteBufMapper;
import org.opendaylight.controller.raft.journal.RaftJournal;
import org.opendaylight.controller.raft.journal.ToByteBufMapper;

public final class SegmentedJournal<E>
implements Journal<E> {
    private final @NonNull SegmentedJournalWriter<E> writer;
    private final @NonNull FromByteBufMapper<E> readMapper;
    private final @NonNull RaftJournal journal;

    public SegmentedJournal(RaftJournal journal, FromByteBufMapper<E> readMapper, ToByteBufMapper<E> writeMapper) {
        this.journal = Objects.requireNonNull(journal, "journal is required");
        this.readMapper = Objects.requireNonNull(readMapper, "readMapper cannot be null");
        this.writer = new SegmentedJournalWriter<E>(journal.writer(), Objects.requireNonNull(writeMapper, "writeMapper cannot be null"));
    }

    @Override
    public long firstIndex() {
        return this.journal.firstIndex();
    }

    @Override
    public long lastIndex() {
        return this.journal.lastIndex();
    }

    @Override
    public JournalWriter<E> writer() {
        return this.writer;
    }

    @Override
    public JournalReader<E> openReader(long index) {
        return this.openReader(index, JournalReader.Mode.ALL);
    }

    @Override
    public JournalReader<E> openReader(long index, JournalReader.Mode mode) {
        EntryReader byteReader = switch (mode) {
            default -> throw new MatchException(null, null);
            case JournalReader.Mode.ALL -> this.journal.openReader(index);
            case JournalReader.Mode.COMMITS -> this.journal.openCommitsReader(index);
        };
        return new SegmentedJournalReader<E>(byteReader, this.readMapper);
    }

    @Override
    public void compact(long index) {
        this.journal.compact(index);
    }

    @Override
    public void close() {
        this.journal.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("journal", (Object)this.journal).toString();
    }
}

