/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal;

import io.atomix.storage.journal.JournalReader;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.raft.journal.EntryReader;
import org.opendaylight.controller.raft.journal.FromByteBufMapper;

@NonNullByDefault
final class SegmentedJournalReader<E>
implements JournalReader<E> {
    private final FromByteBufMapper<E> mapper;
    private final EntryReader reader;

    SegmentedJournalReader(EntryReader reader, FromByteBufMapper<E> mapper) {
        this.reader = Objects.requireNonNull(reader);
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public long getNextIndex() {
        return this.reader.nextIndex();
    }

    @Override
    public void reset() {
        this.reader.reset();
    }

    @Override
    public void reset(long index) {
        this.reader.reset(index);
    }

    @Override
    public <T> @Nullable T tryNext(JournalReader.EntryMapper<E, T> entryMapper) {
        return (T)this.reader.tryNext((index, buf) -> {
            int size = buf.readableBytes();
            return Objects.requireNonNull(entryMapper.mapEntry(index, this.mapper.bytesToObject(index, buf), size));
        });
    }

    @Override
    public void close() {
        this.reader.close();
    }
}

