/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.journal.index;

import com.google.common.base.MoreObjects;
import io.atomix.storage.journal.index.JournalIndex;
import io.atomix.storage.journal.index.Position;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;

public final class SparseJournalIndex
implements JournalIndex {
    private static final int MIN_DENSITY = 1000;
    private final TreeMap<Long, Integer> positions = new TreeMap();
    private final int density;
    private @Nullable Position last;

    public SparseJournalIndex() {
        this.density = 1000;
    }

    public SparseJournalIndex(double density) {
        this.density = (int)Math.ceil(1000.0 / (density * 1000.0));
    }

    @Override
    public Position index(long index, int position) {
        Position newLast;
        this.last = newLast = new Position(index, position);
        if (index % (long)this.density == 0L) {
            this.positions.put(index, position);
        }
        return newLast;
    }

    @Override
    public Position last() {
        return this.last;
    }

    @Override
    public Position lookup(long index) {
        return Position.ofNullable(this.positions.floorEntry(index));
    }

    @Override
    public Position truncate(long index) {
        Position newLast;
        NavigableMap<Long, Integer> tailMap = this.positions.tailMap(index, true);
        Map.Entry<Long, Integer> firstRemoved = tailMap.firstEntry();
        tailMap.clear();
        this.last = newLast = Position.ofNullable(this.positions.lastEntry());
        return firstRemoved != null && firstRemoved.getKey() == index ? new Position(firstRemoved) : newLast;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("positions", this.positions).toString();
    }
}

