/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import com.esotericsoftware.kryo.io.ByteBufferInput;
import java.nio.ByteBuffer;

public final class Kryo505ByteBufferInput
extends ByteBufferInput {
    Kryo505ByteBufferInput(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public String readString() {
        this.niobuffer.position(this.position);
        int available = this.require(1);
        ++this.position;
        byte b = this.niobuffer.get();
        if ((b & 0x80) == 0) {
            return this.readAscii();
        }
        int charCount = available >= 5 ? this.readUtf8Length(b) : this.readUtf8Length_slow(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        this.readUtf8(charCount);
        return new String(this.chars, 0, charCount);
    }

    private int readUtf8Length(int b) {
        int result = b & 0x3F;
        if ((b & 0x40) != 0) {
            ++this.position;
            b = this.niobuffer.get();
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                ++this.position;
                b = this.niobuffer.get();
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    ++this.position;
                    b = this.niobuffer.get();
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        ++this.position;
                        b = this.niobuffer.get();
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return result;
    }

    private int readUtf8Length_slow(int b) {
        int result = b & 0x3F;
        if ((b & 0x40) != 0) {
            this.require(1);
            ++this.position;
            b = this.niobuffer.get();
            result |= (b & 0x7F) << 6;
            if ((b & 0x80) != 0) {
                this.require(1);
                ++this.position;
                b = this.niobuffer.get();
                result |= (b & 0x7F) << 13;
                if ((b & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    b = this.niobuffer.get();
                    result |= (b & 0x7F) << 20;
                    if ((b & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        b = this.niobuffer.get();
                        result |= (b & 0x7F) << 27;
                    }
                }
            }
        }
        return result;
    }

    private void readUtf8(int charCount) {
        char[] chars = this.chars;
        int charIndex = 0;
        int count = Math.min(this.require(1), charCount);
        int position = this.position;
        while (charIndex < count) {
            ++position;
            byte b = this.niobuffer.get();
            if (b < 0) {
                --position;
                break;
            }
            chars[charIndex++] = (char)b;
        }
        this.position = position;
        if (charIndex < charCount) {
            this.niobuffer.position(position);
            this.readUtf8_slow(charCount, charIndex);
        }
    }

    private void readUtf8_slow(int charCount, int charIndex) {
        char[] chars = this.chars;
        while (charIndex < charCount) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ++this.position;
            int b = this.niobuffer.get() & 0xFF;
            switch (b >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    chars[charIndex] = (char)b;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    ++this.position;
                    chars[charIndex] = (char)((b & 0x1F) << 6 | this.niobuffer.get() & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    this.position += 2;
                    byte b2 = this.niobuffer.get();
                    byte b3 = this.niobuffer.get();
                    chars[charIndex] = (char)((b & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                }
            }
            ++charIndex;
        }
    }

    private String readAscii() {
        byte b;
        int end = this.position;
        int start = end - 1;
        int limit = this.limit;
        do {
            if (end == limit) {
                return this.readAscii_slow();
            }
            ++end;
        } while (((b = this.niobuffer.get()) & 0x80) == 0);
        int count = end - start;
        byte[] tmp = new byte[count];
        this.niobuffer.position(start);
        this.niobuffer.get(tmp);
        int n = count - 1;
        tmp[n] = (byte)(tmp[n] & 0x7F);
        String value = new String(tmp, 0, 0, count);
        this.position = end;
        this.niobuffer.position(this.position);
        return value;
    }

    private String readAscii_slow() {
        byte b;
        --this.position;
        int charCount = this.limit - this.position;
        if (charCount > this.chars.length) {
            this.chars = new char[charCount * 2];
        }
        char[] chars = this.chars;
        int i = this.position;
        int ii = 0;
        int n = this.limit;
        while (i < n) {
            chars[ii] = (char)this.niobuffer.get(i);
            ++i;
            ++ii;
        }
        this.position = this.limit;
        while (true) {
            this.require(1);
            ++this.position;
            b = this.niobuffer.get();
            if (charCount == chars.length) {
                char[] newChars = new char[charCount * 2];
                System.arraycopy(chars, 0, newChars, 0, charCount);
                chars = newChars;
                this.chars = newChars;
            }
            if ((b & 0x80) == 128) break;
            chars[charCount++] = (char)b;
        }
        chars[charCount++] = (char)(b & 0x7F);
        return new String(chars, 0, charCount);
    }

    @Override
    public StringBuilder readStringBuilder() {
        this.niobuffer.position(this.position);
        int available = this.require(1);
        ++this.position;
        byte b = this.niobuffer.get();
        if ((b & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int charCount = available >= 5 ? this.readUtf8Length(b) : this.readUtf8Length_slow(b);
        switch (charCount) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        if (this.chars.length < --charCount) {
            this.chars = new char[charCount];
        }
        this.readUtf8(charCount);
        StringBuilder builder = new StringBuilder(charCount);
        builder.append(this.chars, 0, charCount);
        return builder;
    }
}

