/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.binding.dom.adapter;

import com.google.common.base.Verify;
import java.util.Objects;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.eos.binding.api.Entity;
import org.opendaylight.mdsal.eos.binding.api.EntityOwnershipListener;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipStateChange;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DOMEntityOwnershipListenerAdapter
implements DOMEntityOwnershipListener {
    private static final Logger LOG = LoggerFactory.getLogger(DOMEntityOwnershipListenerAdapter.class);
    private final EntityOwnershipListener bindingListener;
    private final AdapterContext adapterContext;

    DOMEntityOwnershipListenerAdapter(EntityOwnershipListener bindingListener, AdapterContext adapterContext) {
        this.bindingListener = Objects.requireNonNull(bindingListener);
        this.adapterContext = Objects.requireNonNull(adapterContext);
    }

    public void ownershipChanged(DOMEntity entity, EntityOwnershipStateChange change, boolean inJeopardy) {
        DataObjectReference bindingId;
        YangInstanceIdentifier domId = (YangInstanceIdentifier)entity.getIdentifier();
        try {
            bindingId = (DataObjectReference)Verify.verifyNotNull((Object)this.adapterContext.currentSerializer().fromYangInstanceIdentifier(domId));
        }
        catch (RuntimeException e) {
            LOG.error("Error converting DOM entity ID {} to binding InstanceIdentifier", (Object)domId, (Object)e);
            return;
        }
        Entity bindingEntity = new Entity(entity.getType(), bindingId.toLegacy());
        try {
            this.bindingListener.ownershipChanged(bindingEntity, change, inJeopardy);
        }
        catch (Exception e) {
            LOG.error("Listener {} failed on during {} {}change {}", new Object[]{this.bindingListener, bindingEntity, inJeopardy ? "jeopardy " : "", change, e});
        }
    }
}

