/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMActionAvailabilityExtension;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMOperationImplementation;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRoutingTableEntry;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

@Beta
final class DOMActionRoutingTableEntry
extends AbstractDOMRoutingTableEntry<DOMDataTreeIdentifier, DOMActionImplementation, DOMActionAvailabilityExtension.AvailabilityListener, SchemaNodeIdentifier.Absolute> {
    private static final Comparator<DOMActionImplementation> COMPARATOR = Comparator.comparingLong(DOMOperationImplementation::invocationCost);

    DOMActionRoutingTableEntry(SchemaNodeIdentifier.Absolute type, Map<DOMDataTreeIdentifier, List<DOMActionImplementation>> implementations) {
        super(type, implementations);
    }

    @Override
    protected Set<DOMDataTreeIdentifier> registeredIdentifiers(DOMActionAvailabilityExtension.AvailabilityListener listener) {
        return Maps.filterValues(this.getImplementations(), list -> list.stream().anyMatch(arg_0 -> ((DOMActionAvailabilityExtension.AvailabilityListener)listener).acceptsImplementation(arg_0))).keySet();
    }

    @Override
    protected Comparator<DOMActionImplementation> implComparator() {
        return COMPARATOR;
    }

    protected DOMActionRoutingTableEntry newInstance(Map<DOMDataTreeIdentifier, List<DOMActionImplementation>> impls) {
        return new DOMActionRoutingTableEntry((SchemaNodeIdentifier.Absolute)this.getType(), impls);
    }
}

