/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.mdsal.dom.api.DOMActionAvailabilityExtension;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.mdsal.dom.api.DOMActionNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementationNotAvailableException;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRpcRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.DOMActionRoutingTable;
import org.opendaylight.mdsal.dom.broker.DOMActionRoutingTableEntry;
import org.opendaylight.mdsal.dom.broker.DOMRpcRoutingTable;
import org.opendaylight.mdsal.dom.broker.OperationInvocation;
import org.opendaylight.yangtools.concepts.AbstractRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={DOMRpcRouter.class})
public final class DOMRpcRouter
extends AbstractRegistration {
    private static final Logger LOG = LoggerFactory.getLogger(DOMRpcRouter.class);
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("DOMRpcRouter-listener-%s").setDaemon(true).build();
    private final ExecutorService listenerNotifier = Executors.newSingleThreadExecutor(THREAD_FACTORY);
    private final @NonNull DOMActionProviderService actionProviderService = new ActionProviderServiceFacade();
    private final @NonNull DOMActionService actionService = new ActionServiceFacade();
    private final @NonNull DOMRpcProviderService rpcProviderService = new RpcProviderServiceFacade();
    private final @NonNull DOMRpcService rpcService = new RpcServiceFacade();
    private @GuardedBy(value={"this"}) ImmutableList<RpcAvailReg> listeners = ImmutableList.of();
    private @GuardedBy(value={"this"}) ImmutableList<ActionAvailReg> actionListeners = ImmutableList.of();
    private volatile DOMRpcRoutingTable routingTable = DOMRpcRoutingTable.EMPTY;
    private volatile DOMActionRoutingTable actionRoutingTable = DOMActionRoutingTable.EMPTY;
    private Registration listenerRegistration;

    @Deprecated
    @VisibleForTesting
    public DOMRpcRouter() {
    }

    @Inject
    @Activate
    public DOMRpcRouter(@Reference DOMSchemaService schemaService) {
        this.listenerRegistration = schemaService.registerSchemaContextListener(this::onModelContextUpdated);
        LOG.info("DOM RPC/Action router started");
    }

    @Deprecated(forRemoval=true)
    public static DOMRpcRouter newInstance(DOMSchemaService schemaService) {
        return new DOMRpcRouter(schemaService);
    }

    @PreDestroy
    @Deactivate
    public void shutdown() {
        this.close();
    }

    public @NonNull DOMActionService actionService() {
        return this.actionService;
    }

    public @NonNull DOMActionProviderService actionProviderService() {
        return this.actionProviderService;
    }

    public @NonNull DOMRpcService rpcService() {
        return this.rpcService;
    }

    public @NonNull DOMRpcProviderService rpcProviderService() {
        return this.rpcProviderService;
    }

    private synchronized void removeRpcImplementation(DOMRpcImplementation implementation, Set<DOMRpcIdentifier> rpcs) {
        DOMRpcRoutingTable newTable;
        DOMRpcRoutingTable oldTable = this.routingTable;
        this.routingTable = newTable = (DOMRpcRoutingTable)oldTable.remove(implementation, rpcs);
        this.listenerNotifier.execute(() -> this.notifyRemoved(newTable, implementation));
    }

    private synchronized void removeRpcImplementations(ImmutableTable<QName, YangInstanceIdentifier, DOMRpcImplementation> implTable) {
        DOMRpcRoutingTable newTable;
        DOMRpcRoutingTable oldTable = this.routingTable;
        this.routingTable = newTable = (DOMRpcRoutingTable)oldTable.removeAll(implTable);
        this.listenerNotifier.execute(() -> this.notifyRemoved(newTable, (Collection<? extends DOMRpcImplementation>)implTable.values()));
    }

    private synchronized void removeActionImplementation(DOMActionImplementation implementation, Set<DOMActionInstance> actions) {
        DOMActionRoutingTable newTable;
        DOMActionRoutingTable oldTable = this.actionRoutingTable;
        this.actionRoutingTable = newTable = (DOMActionRoutingTable)oldTable.remove(implementation, actions);
        this.listenerNotifier.execute(() -> this.notifyActionChanged(newTable, implementation));
    }

    private synchronized void removeListener(RpcAvailReg reg) {
        this.listeners = ImmutableList.copyOf((Collection)Collections2.filter(this.listeners, input -> !((Object)((Object)reg)).equals(input)));
    }

    private synchronized void removeActionListener(ActionAvailReg reg) {
        this.actionListeners = ImmutableList.copyOf((Collection)Collections2.filter(this.actionListeners, input -> !((Object)((Object)reg)).equals(input)));
    }

    private synchronized void notifyAdded(DOMRpcRoutingTable newTable, DOMRpcImplementation impl) {
        for (RpcAvailReg l : this.listeners) {
            l.addRpc(newTable, impl);
        }
    }

    private synchronized void notifyAdded(DOMRpcRoutingTable newTable, Collection<? extends DOMRpcImplementation> impls) {
        for (RpcAvailReg l : this.listeners) {
            for (DOMRpcImplementation impl : impls) {
                l.addRpc(newTable, impl);
            }
        }
    }

    private synchronized void notifyRemoved(DOMRpcRoutingTable newTable, DOMRpcImplementation impl) {
        for (RpcAvailReg l : this.listeners) {
            l.removeRpc(newTable, impl);
        }
    }

    private synchronized void notifyRemoved(DOMRpcRoutingTable newTable, Collection<? extends DOMRpcImplementation> impls) {
        for (RpcAvailReg l : this.listeners) {
            for (DOMRpcImplementation impl : impls) {
                l.removeRpc(newTable, impl);
            }
        }
    }

    private synchronized void notifyActionChanged(DOMActionRoutingTable newTable, DOMActionImplementation impl) {
        for (ActionAvailReg l : this.actionListeners) {
            l.actionChanged(newTable, impl);
        }
    }

    synchronized void onModelContextUpdated(@NonNull EffectiveModelContext newModelContext) {
        DOMActionRoutingTable newActionTable;
        DOMRpcRoutingTable newTable;
        DOMRpcRoutingTable oldTable = this.routingTable;
        this.routingTable = newTable = (DOMRpcRoutingTable)oldTable.setSchemaContext(newModelContext);
        DOMActionRoutingTable oldActionTable = this.actionRoutingTable;
        this.actionRoutingTable = newActionTable = (DOMActionRoutingTable)oldActionTable.setSchemaContext(newModelContext);
    }

    protected void removeRegistration() {
        if (this.listenerRegistration != null) {
            this.listenerRegistration.close();
            this.listenerRegistration = null;
        }
        this.listenerNotifier.shutdown();
        LOG.info("DOM RPC/Action router stopped");
    }

    @VisibleForTesting
    synchronized List<?> listeners() {
        return this.listeners;
    }

    @VisibleForTesting
    synchronized List<?> actionListeners() {
        return this.actionListeners;
    }

    @VisibleForTesting
    DOMRpcRoutingTable routingTable() {
        return this.routingTable;
    }

    @NonNullByDefault
    private final class ActionProviderServiceFacade
    implements DOMActionProviderService {
        private ActionProviderServiceFacade() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Registration registerActionImplementation(final DOMActionImplementation implementation, final Set<DOMActionInstance> instances) {
            Preconditions.checkArgument((!instances.isEmpty() ? 1 : 0) != 0, (Object)"Instances must not be empty");
            DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
            synchronized (dOMRpcRouter) {
                DOMActionRoutingTable newTable;
                DOMActionRoutingTable oldTable = DOMRpcRouter.this.actionRoutingTable;
                DOMRpcRouter.this.actionRoutingTable = newTable = (DOMActionRoutingTable)oldTable.add(implementation, instances);
                DOMRpcRouter.this.listenerNotifier.execute(() -> DOMRpcRouter.this.notifyActionChanged(newTable, implementation));
            }
            return new AbstractRegistration(){

                protected void removeRegistration() {
                    DOMRpcRouter.this.removeActionImplementation(implementation, instances);
                }
            };
        }
    }

    @NonNullByDefault
    private final class ActionServiceFacade
    implements DOMActionService,
    DOMActionAvailabilityExtension {
        private ActionServiceFacade() {
        }

        public List<DOMActionService.Extension> supportedExtensions() {
            return List.of(this);
        }

        public ListenableFuture<? extends DOMRpcResult> invokeAction(SchemaNodeIdentifier.Absolute type, DOMDataTreeIdentifier path, ContainerNode input) {
            YangInstanceIdentifier pathRoot = path.path();
            Preconditions.checkArgument((!pathRoot.isEmpty() ? 1 : 0) != 0, (Object)"Action path must not be empty");
            DOMActionRoutingTableEntry entry = (DOMActionRoutingTableEntry)DOMRpcRouter.this.actionRoutingTable.getEntry(type);
            return entry != null ? OperationInvocation.invoke(entry, type, path, Objects.requireNonNull(input)) : Futures.immediateFailedFuture((Throwable)new DOMActionNotAvailableException("No implementation of Action %s available", new Object[]{type}));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Registration registerAvailabilityListener(DOMActionAvailabilityExtension.AvailabilityListener listener) {
            DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
            synchronized (dOMRpcRouter) {
                ActionAvailReg ret = new ActionAvailReg(DOMRpcRouter.this, listener, DOMRpcRouter.this.actionRoutingTable.getOperations(listener));
                DOMRpcRouter.this.actionListeners = ImmutableList.builder().addAll(DOMRpcRouter.this.actionListeners).add((Object)ret).build();
                DOMRpcRouter.this.listenerNotifier.execute(ret::initialTable);
                return ret;
            }
        }
    }

    private final class RpcProviderServiceFacade
    implements DOMRpcProviderService {
        private RpcProviderServiceFacade() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Registration registerRpcImplementation(final DOMRpcImplementation implementation, final Set<DOMRpcIdentifier> rpcs) {
            DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
            synchronized (dOMRpcRouter) {
                DOMRpcRoutingTable newTable;
                DOMRpcRoutingTable oldTable = DOMRpcRouter.this.routingTable;
                DOMRpcRouter.this.routingTable = newTable = (DOMRpcRoutingTable)oldTable.add(implementation, rpcs);
                DOMRpcRouter.this.listenerNotifier.execute(() -> DOMRpcRouter.this.notifyAdded(newTable, implementation));
            }
            return new AbstractRegistration(){

                protected void removeRegistration() {
                    DOMRpcRouter.this.removeRpcImplementation(implementation, rpcs);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Registration registerRpcImplementations(Map<DOMRpcIdentifier, DOMRpcImplementation> map) {
            Preconditions.checkArgument((!map.isEmpty() ? 1 : 0) != 0);
            ImmutableTable.Builder builder = ImmutableTable.builder();
            for (Map.Entry<DOMRpcIdentifier, DOMRpcImplementation> entry : map.entrySet()) {
                DOMRpcIdentifier id = entry.getKey();
                builder.put((Object)id.getType(), (Object)id.getContextReference(), (Object)entry.getValue());
            }
            final ImmutableTable implTable = builder.build();
            DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
            synchronized (dOMRpcRouter) {
                DOMRpcRoutingTable newTable;
                DOMRpcRoutingTable oldTable = DOMRpcRouter.this.routingTable;
                DOMRpcRouter.this.routingTable = newTable = (DOMRpcRoutingTable)oldTable.addAll(implTable);
                DOMRpcRouter.this.listenerNotifier.execute(() -> DOMRpcRouter.this.notifyAdded(newTable, (Collection<? extends DOMRpcImplementation>)implTable.values()));
            }
            return new AbstractRegistration(){

                protected void removeRegistration() {
                    DOMRpcRouter.this.removeRpcImplementations((ImmutableTable<QName, YangInstanceIdentifier, DOMRpcImplementation>)implTable);
                }
            };
        }
    }

    private final class RpcServiceFacade
    implements DOMRpcService {
        private RpcServiceFacade() {
        }

        public ListenableFuture<? extends DOMRpcResult> invokeRpc(QName type, ContainerNode input) {
            AbstractDOMRpcRoutingTableEntry entry = (AbstractDOMRpcRoutingTableEntry)DOMRpcRouter.this.routingTable.getEntry(type);
            if (entry == null) {
                return Futures.immediateFailedFuture((Throwable)new DOMRpcImplementationNotAvailableException("No implementation of RPC %s available", new Object[]{type}));
            }
            return OperationInvocation.invoke(entry, Objects.requireNonNull(input));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Registration registerRpcListener(DOMRpcAvailabilityListener listener) {
            DOMRpcRouter dOMRpcRouter = DOMRpcRouter.this;
            synchronized (dOMRpcRouter) {
                RpcAvailReg ret = new RpcAvailReg(DOMRpcRouter.this, listener, DOMRpcRouter.this.routingTable.getOperations(listener));
                DOMRpcRouter.this.listeners = ImmutableList.builder().addAll(DOMRpcRouter.this.listeners).add((Object)ret).build();
                DOMRpcRouter.this.listenerNotifier.execute(ret::initialTable);
                return ret;
            }
        }
    }

    private static final class RpcAvailReg
    extends AbstractRegistration {
        private final DOMRpcAvailabilityListener listener;
        private Map<QName, Set<YangInstanceIdentifier>> prevRpcs;
        private DOMRpcRouter router;

        RpcAvailReg(DOMRpcRouter router, DOMRpcAvailabilityListener listener, Map<QName, Set<YangInstanceIdentifier>> rpcs) {
            this.listener = Objects.requireNonNull(listener);
            this.router = Objects.requireNonNull(router);
            this.prevRpcs = Objects.requireNonNull(rpcs);
        }

        protected void removeRegistration() {
            this.router.removeListener(this);
            this.router = null;
        }

        void initialTable() {
            ArrayList added = new ArrayList();
            for (Map.Entry<QName, Set<YangInstanceIdentifier>> e : this.prevRpcs.entrySet()) {
                added.addAll(Collections2.transform((Collection)e.getValue(), i -> DOMRpcIdentifier.create((QName)((QName)e.getKey()), (YangInstanceIdentifier)i)));
            }
            if (!added.isEmpty()) {
                this.listener.onRpcAvailable(added);
            }
        }

        void addRpc(DOMRpcRoutingTable newTable, DOMRpcImplementation impl) {
            if (!this.listener.acceptsImplementation(impl)) {
                return;
            }
            Map rpcs = (Map)Verify.verifyNotNull(newTable.getOperations(this.listener));
            MapDifference diff = Maps.difference(this.prevRpcs, (Map)rpcs);
            ArrayList<DOMRpcIdentifier> added = new ArrayList<DOMRpcIdentifier>();
            for (Map.Entry e : diff.entriesOnlyOnRight().entrySet()) {
                added.addAll(Collections2.transform((Collection)((Collection)e.getValue()), i -> DOMRpcIdentifier.create((QName)((QName)e.getKey()), (YangInstanceIdentifier)i)));
            }
            for (Map.Entry e : diff.entriesDiffering().entrySet()) {
                for (YangInstanceIdentifier i2 : Sets.difference((Set)((Set)((MapDifference.ValueDifference)e.getValue()).rightValue()), (Set)((Set)((MapDifference.ValueDifference)e.getValue()).leftValue()))) {
                    added.add(DOMRpcIdentifier.create((QName)((QName)e.getKey()), (YangInstanceIdentifier)i2));
                }
            }
            this.prevRpcs = rpcs;
            if (!added.isEmpty()) {
                this.listener.onRpcAvailable(added);
            }
        }

        void removeRpc(DOMRpcRoutingTable newTable, DOMRpcImplementation impl) {
            if (!this.listener.acceptsImplementation(impl)) {
                return;
            }
            Map rpcs = (Map)Verify.verifyNotNull(newTable.getOperations(this.listener));
            MapDifference diff = Maps.difference(this.prevRpcs, (Map)rpcs);
            ArrayList<DOMRpcIdentifier> removed = new ArrayList<DOMRpcIdentifier>();
            for (Map.Entry e : diff.entriesOnlyOnLeft().entrySet()) {
                removed.addAll(Collections2.transform((Collection)((Collection)e.getValue()), i -> DOMRpcIdentifier.create((QName)((QName)e.getKey()), (YangInstanceIdentifier)i)));
            }
            for (Map.Entry e : diff.entriesDiffering().entrySet()) {
                for (YangInstanceIdentifier i2 : Sets.difference((Set)((Set)((MapDifference.ValueDifference)e.getValue()).leftValue()), (Set)((Set)((MapDifference.ValueDifference)e.getValue()).rightValue()))) {
                    removed.add(DOMRpcIdentifier.create((QName)((QName)e.getKey()), (YangInstanceIdentifier)i2));
                }
            }
            this.prevRpcs = rpcs;
            if (!removed.isEmpty()) {
                this.listener.onRpcUnavailable(removed);
            }
        }
    }

    private static final class ActionAvailReg
    extends AbstractRegistration {
        private final DOMActionAvailabilityExtension.AvailabilityListener listener;
        private Map<SchemaNodeIdentifier.Absolute, Set<DOMDataTreeIdentifier>> prevActions;
        private DOMRpcRouter router;

        ActionAvailReg(DOMRpcRouter router, DOMActionAvailabilityExtension.AvailabilityListener listener, Map<SchemaNodeIdentifier.Absolute, Set<DOMDataTreeIdentifier>> actions) {
            this.listener = Objects.requireNonNull(listener);
            this.router = Objects.requireNonNull(router);
            this.prevActions = Objects.requireNonNull(actions);
        }

        protected void removeRegistration() {
            this.router.removeActionListener(this);
            this.router = null;
        }

        void initialTable() {
            ArrayList added = new ArrayList();
            for (Map.Entry<SchemaNodeIdentifier.Absolute, Set<DOMDataTreeIdentifier>> e : this.prevActions.entrySet()) {
                added.addAll(Collections2.transform((Collection)e.getValue(), i -> DOMActionInstance.of((SchemaNodeIdentifier.Absolute)((SchemaNodeIdentifier.Absolute)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i})));
            }
            if (!added.isEmpty()) {
                this.listener.onActionsChanged((Set)ImmutableSet.of(), (Set)ImmutableSet.copyOf(added));
            }
        }

        void actionChanged(DOMActionRoutingTable newTable, DOMActionImplementation impl) {
            if (!this.listener.acceptsImplementation(impl)) {
                return;
            }
            Map actions = (Map)Verify.verifyNotNull(newTable.getOperations(this.listener));
            MapDifference diff = Maps.difference(this.prevActions, (Map)actions);
            HashSet<DOMActionInstance> removed = new HashSet<DOMActionInstance>();
            HashSet<DOMActionInstance> added = new HashSet<DOMActionInstance>();
            for (Map.Entry e : diff.entriesOnlyOnLeft().entrySet()) {
                removed.addAll(Collections2.transform((Collection)((Collection)e.getValue()), i -> DOMActionInstance.of((SchemaNodeIdentifier.Absolute)((SchemaNodeIdentifier.Absolute)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i})));
            }
            for (Map.Entry e : diff.entriesOnlyOnRight().entrySet()) {
                added.addAll(Collections2.transform((Collection)((Collection)e.getValue()), i -> DOMActionInstance.of((SchemaNodeIdentifier.Absolute)((SchemaNodeIdentifier.Absolute)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i})));
            }
            for (Map.Entry e : diff.entriesDiffering().entrySet()) {
                for (DOMDataTreeIdentifier i2 : Sets.difference((Set)((Set)((MapDifference.ValueDifference)e.getValue()).leftValue()), (Set)((Set)((MapDifference.ValueDifference)e.getValue()).rightValue()))) {
                    removed.add(DOMActionInstance.of((SchemaNodeIdentifier.Absolute)((SchemaNodeIdentifier.Absolute)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i2}));
                }
                for (DOMDataTreeIdentifier i2 : Sets.difference((Set)((Set)((MapDifference.ValueDifference)e.getValue()).rightValue()), (Set)((Set)((MapDifference.ValueDifference)e.getValue()).leftValue()))) {
                    added.add(DOMActionInstance.of((SchemaNodeIdentifier.Absolute)((SchemaNodeIdentifier.Absolute)e.getKey()), (DOMDataTreeIdentifier[])new DOMDataTreeIdentifier[]{i2}));
                }
            }
            this.prevActions = actions;
            if (!removed.isEmpty() || !added.isEmpty()) {
                this.listener.onActionsChanged(removed, added);
            }
        }
    }
}

