/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.TransactionCommitFailedException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.broker.CommitCoordinationTask;
import org.opendaylight.mdsal.dom.spi.AbstractDOMDataBroker;
import org.opendaylight.mdsal.dom.spi.store.DOMStore;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreThreePhaseCommitCohort;
import org.opendaylight.yangtools.util.DurationStatisticsTracker;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializedDOMDataBroker
extends AbstractDOMDataBroker {
    private static final Logger LOG = LoggerFactory.getLogger(SerializedDOMDataBroker.class);
    private final DurationStatisticsTracker commitStatsTracker = DurationStatisticsTracker.createConcurrent();
    private final Executor executor;

    public SerializedDOMDataBroker(Map<LogicalDatastoreType, DOMStore> datastores, Executor executor) {
        super(datastores);
        this.executor = Objects.requireNonNull(executor, "executor must not be null.");
    }

    public DurationStatisticsTracker getCommitStatsTracker() {
        return this.commitStatsTracker;
    }

    protected FluentFuture<CommitInfo> commit(DOMDataTreeWriteTransaction transaction, DOMStoreThreePhaseCommitCohort cohort) {
        ListenableFuture future;
        LOG.debug("Tx: {} is submitted for execution.", transaction.getIdentifier());
        try {
            future = Futures.submit((Callable)new CommitCoordinationTask.WithTracker(transaction, cohort, this.commitStatsTracker), (Executor)this.executor);
        }
        catch (RejectedExecutionException e) {
            LOG.error("The commit executor's queue is full - submit task was rejected. \n{}", (Object)this.executor, (Object)e);
            return FluentFutures.immediateFailedFluentFuture((Throwable)new TransactionCommitFailedException("Could not submit the commit task - the commit queue capacity has been exceeded.", (Throwable)e, new RpcError[0]));
        }
        return FluentFuture.from((ListenableFuture)future);
    }
}

