/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.NetconfLayer;

@NonNullByDefault
public enum ErrorType {
    TRANSPORT("transport", NetconfLayer.TRANSPORT),
    RPC("rpc", NetconfLayer.RPC),
    PROTOCOL("protocol", NetconfLayer.OPERATIONS),
    APPLICATION("application", NetconfLayer.CONTENT);

    private static final Map<String, ErrorType> BY_ELEMENT_BODY;
    private final String elementBody;
    private final NetconfLayer layer;

    private ErrorType(String elementName, NetconfLayer layer) {
        this.elementBody = Objects.requireNonNull(elementName);
        this.layer = Objects.requireNonNull(layer);
    }

    public String elementBody() {
        return this.elementBody;
    }

    public final NetconfLayer layer() {
        return this.layer;
    }

    public static @Nullable ErrorType forElementBody(String elementBody) {
        return BY_ELEMENT_BODY.get(Objects.requireNonNull(elementBody));
    }

    static {
        BY_ELEMENT_BODY = Maps.uniqueIndex(Arrays.asList(ErrorType.values()), ErrorType::elementBody);
    }
}

