/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.ri.generated.type.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.model.api.AbstractType;
import org.opendaylight.yangtools.binding.model.api.AnnotationType;
import org.opendaylight.yangtools.binding.model.api.Constant;
import org.opendaylight.yangtools.binding.model.api.Enumeration;
import org.opendaylight.yangtools.binding.model.api.GeneratedProperty;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.YangSourceDefinition;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotationTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.EnumBuilder;
import org.opendaylight.yangtools.binding.model.ri.generated.type.builder.AnnotationTypeBuilderImpl;
import org.opendaylight.yangtools.util.LazyCollections;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

public abstract class AbstractEnumerationBuilder
extends AbstractType
implements EnumBuilder {
    private List<Enumeration.Pair> values = ImmutableList.of();
    private List<AnnotationTypeBuilder> annotationBuilders = ImmutableList.of();

    AbstractEnumerationBuilder(JavaTypeName identifier) {
        super(identifier);
    }

    @Override
    public final AnnotationTypeBuilder addAnnotation(JavaTypeName identifier) {
        AnnotationTypeBuilderImpl builder = new AnnotationTypeBuilderImpl(identifier);
        if (!this.annotationBuilders.contains(builder)) {
            this.annotationBuilders = LazyCollections.lazyAdd(this.annotationBuilders, (Object)builder);
            return builder;
        }
        return null;
    }

    @VisibleForTesting
    final void addValue(String name, String mappedName, int value, Status status, String description, String reference) {
        this.values = LazyCollections.lazyAdd(this.values, (Object)this.createEnumPair(name, mappedName, value, status, description, reference));
    }

    public abstract void setReference(String var1);

    public abstract void setModuleName(String var1);

    public abstract void setYangSourceDefinition(YangSourceDefinition var1);

    abstract AbstractPair createEnumPair(String var1, String var2, int var3, Status var4, String var5, String var6);

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("values", this.values);
    }

    @Override
    public final void updateEnumPairsFromEnumTypeDef(EnumTypeDefinition enumTypeDef) {
        List enums = enumTypeDef.getValues();
        BiMap valueIds = Naming.mapEnumAssignedNames((Collection)enums.stream().map(EnumTypeDefinition.EnumPair::getName).collect(Collectors.toList()));
        for (EnumTypeDefinition.EnumPair enumPair : enums) {
            this.addValue(enumPair.getName(), (String)valueIds.get(enumPair.getName()), enumPair.getValue(), enumPair.getStatus(), enumPair.getDescription().orElse(null), enumPair.getReference().orElse(null));
        }
    }

    static abstract class AbstractPair
    implements Enumeration.Pair {
        private final String name;
        private final String mappedName;
        private final int value;

        AbstractPair(String name, String mappedName, int value) {
            this.name = Objects.requireNonNull(name);
            this.mappedName = Objects.requireNonNull(mappedName);
            this.value = value;
        }

        @Override
        public final String getName() {
            return this.name;
        }

        @Override
        public final String getMappedName() {
            return this.mappedName;
        }

        @Override
        public final int getValue() {
            return this.value;
        }

        public final int hashCode() {
            return this.name.hashCode() * 31 + this.value;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean equals(Object obj) {
            if (obj == this) return true;
            if (!(obj instanceof AbstractPair)) return false;
            AbstractPair other = (AbstractPair)obj;
            if (!this.name.equals(other.name)) return false;
            if (this.value != other.value) return false;
            return true;
        }

        public final String toString() {
            return "EnumPair [name=" + this.name + ", mappedName=" + this.getMappedName() + ", value=" + this.value + "]";
        }
    }

    static abstract class AbstractEnumeration
    extends AbstractType
    implements Enumeration {
        private final List<AnnotationType> annotations;
        private final List<Enumeration.Pair> values;

        AbstractEnumeration(AbstractEnumerationBuilder builder) {
            super((JavaTypeName)builder.getIdentifier());
            this.values = ImmutableList.copyOf(builder.values);
            this.annotations = (List)builder.annotationBuilders.stream().map(AnnotationTypeBuilder::build).collect(ImmutableList.toImmutableList());
        }

        @Override
        public final List<Enumeration.Pair> getValues() {
            return this.values;
        }

        @Override
        public final List<AnnotationType> getAnnotations() {
            return this.annotations;
        }

        @Override
        public final String toFormattedString() {
            StringBuilder sb = new StringBuilder().append("public enum ").append(this.getName()).append(" {\n");
            int offset = 0;
            for (Enumeration.Pair valPair : this.values) {
                sb.append("\t ").append(valPair.getMappedName()).append(" (").append(valPair.getValue()).append(" )").append(offset == this.values.size() - 1 ? (char)';' : ',');
                ++offset;
            }
            return sb.append("\n}").toString();
        }

        protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
            return super.addToStringAttributes(toStringHelper).add("values", this.values);
        }

        @Override
        public final boolean isAbstract() {
            return false;
        }

        @Override
        public final List<Type> getImplements() {
            return List.of();
        }

        @Override
        public final List<GeneratedType> getEnclosedTypes() {
            return List.of();
        }

        @Override
        public final List<Enumeration> getEnumerations() {
            return List.of();
        }

        @Override
        public final List<Constant> getConstantDefinitions() {
            return List.of();
        }

        @Override
        public final List<MethodSignature> getMethodDefinitions() {
            return List.of();
        }

        @Override
        public final List<GeneratedProperty> getProperties() {
            return List.of();
        }
    }
}

