/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.ri.generated.type.builder;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.binding.model.api.Enumeration;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.TypeComment;
import org.opendaylight.yangtools.binding.model.api.YangSourceDefinition;
import org.opendaylight.yangtools.binding.model.ri.generated.type.builder.AbstractEnumerationBuilder;
import org.opendaylight.yangtools.yang.model.api.Status;

public final class CodegenEnumerationBuilder
extends AbstractEnumerationBuilder {
    private String description;
    private String reference;
    private String moduleName;
    private YangSourceDefinition definition;

    public CodegenEnumerationBuilder(JavaTypeName identifier) {
        super(identifier);
    }

    @Override
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Override
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public void setYangSourceDefinition(YangSourceDefinition yangSourceDefinition) {
        this.definition = yangSourceDefinition;
    }

    @Override
    public Enumeration toInstance() {
        return new EnumerationImpl(this);
    }

    @Override
    EnumPair createEnumPair(String name, String mappedName, int value, Status status, String enumDescription, String enumReference) {
        return new EnumPair(name, mappedName, value, status, enumDescription, enumReference);
    }

    private static final class EnumerationImpl
    extends AbstractEnumerationBuilder.AbstractEnumeration {
        private final String description;
        private final String reference;
        private final String moduleName;
        private final YangSourceDefinition definition;

        EnumerationImpl(CodegenEnumerationBuilder builder) {
            super(builder);
            this.description = builder.description;
            this.moduleName = builder.moduleName;
            this.reference = builder.reference;
            this.definition = builder.definition;
        }

        @Override
        public TypeComment getComment() {
            return null;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getReference() {
            return this.reference;
        }

        @Override
        public String getModuleName() {
            return this.moduleName;
        }

        @Override
        public Optional<YangSourceDefinition> getYangSourceDefinition() {
            return Optional.ofNullable(this.definition);
        }
    }

    private static final class EnumPair
    extends AbstractEnumerationBuilder.AbstractPair {
        private final String description;
        private final String reference;
        private final Status status;

        EnumPair(String name, String mappedName, int value, Status status, String description, String reference) {
            super(name, mappedName, value);
            this.status = Objects.requireNonNull(status);
            this.description = description;
            this.reference = reference;
        }

        public Optional<String> getDescription() {
            return Optional.ofNullable(this.description);
        }

        public Optional<String> getReference() {
            return Optional.ofNullable(this.reference);
        }

        public Status getStatus() {
            return this.status;
        }
    }
}

