/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.registry.candidate;

import akka.actor.ClassicActorSystemProvider;
import akka.actor.typed.ActorRef;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.actor.typed.javadsl.StashBuffer;
import akka.cluster.Cluster;
import akka.japi.function.Function;
import akka.japi.function.Function2;
import java.io.Serializable;
import java.time.Duration;
import java.util.Set;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidatesForMember;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.ClearCandidatesResponse;
import org.opendaylight.controller.eos.akka.owner.supervisor.command.OwnerSupervisorCommand;
import org.opendaylight.controller.eos.akka.registry.candidate.CandidateRegistry;
import org.opendaylight.controller.eos.akka.registry.candidate.command.CandidateRegistryCommand;
import org.opendaylight.controller.eos.akka.registry.candidate.command.CandidateRemovalFailed;
import org.opendaylight.controller.eos.akka.registry.candidate.command.CandidateRemovalFinished;
import org.opendaylight.controller.eos.akka.registry.candidate.command.RegisterCandidate;
import org.opendaylight.controller.eos.akka.registry.candidate.command.RemovePreviousCandidates;
import org.opendaylight.controller.eos.akka.registry.candidate.command.UnregisterCandidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CandidateRegistryInit
extends AbstractBehavior<CandidateRegistryCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(CandidateRegistryInit.class);
    private static final String DATACENTER_PREFIX = "dc-";
    private final StashBuffer<CandidateRegistryCommand> stash;
    private final ActorRef<OwnerSupervisorCommand> ownerSupervisor;
    private final String selfRole;

    public CandidateRegistryInit(ActorContext<CandidateRegistryCommand> ctx, StashBuffer<CandidateRegistryCommand> stash, ActorRef<OwnerSupervisorCommand> ownerSupervisor) {
        super(ctx);
        this.stash = stash;
        this.ownerSupervisor = ownerSupervisor;
        this.selfRole = CandidateRegistryInit.extractRole(Cluster.get((ClassicActorSystemProvider)ctx.getSystem()).selfMember().getRoles());
        ctx.getSelf().tell((Object)new RemovePreviousCandidates());
        LOG.debug("{} : CandidateRegistry syncing behavior started.", (Object)this.selfRole);
    }

    public static Behavior<CandidateRegistryCommand> create(ActorRef<OwnerSupervisorCommand> ownerSupervisor) {
        return Behaviors.withStash((int)100, stash -> Behaviors.setup((Function & Serializable)ctx -> new CandidateRegistryInit((ActorContext<CandidateRegistryCommand>)ctx, (StashBuffer<CandidateRegistryCommand>)stash, ownerSupervisor)));
    }

    public Receive<CandidateRegistryCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(RemovePreviousCandidates.class, this::onRemoveCandidates).onMessage(CandidateRemovalFinished.class, (Function & Serializable)command -> this.switchToCandidateRegistry()).onMessage(CandidateRemovalFailed.class, this::candidateRemovalFailed).onMessage(RegisterCandidate.class, this::stashCommand).onMessage(UnregisterCandidate.class, this::stashCommand).build();
    }

    private Behavior<CandidateRegistryCommand> candidateRemovalFailed(CandidateRemovalFailed command) {
        LOG.warn("{} : Initial removal of candidates from previous iteration failed. Rescheduling.", (Object)this.selfRole, (Object)command.getThrowable());
        this.getContext().getSelf().tell((Object)new RemovePreviousCandidates());
        return this;
    }

    private Behavior<CandidateRegistryCommand> onRemoveCandidates(RemovePreviousCandidates command) {
        LOG.debug("Sending RemovePreviousCandidates.");
        this.getContext().ask(ClearCandidatesResponse.class, this.ownerSupervisor, Duration.ofSeconds(5L), (Function & Serializable)ref -> new ClearCandidatesForMember((ActorRef<ClearCandidatesResponse>)ref, this.selfRole), (Function2 & Serializable)(response, throwable) -> {
            if (response != null) {
                return new CandidateRemovalFinished();
            }
            return new CandidateRemovalFailed((Throwable)throwable);
        });
        return this;
    }

    private Behavior<CandidateRegistryCommand> stashCommand(CandidateRegistryCommand command) {
        LOG.debug("Stashing {}", (Object)command);
        this.stash.stash((Object)command);
        return this;
    }

    private Behavior<CandidateRegistryCommand> switchToCandidateRegistry() {
        LOG.debug("{} : Clearing of candidates from previous instance done, switching to CandidateRegistry.", (Object)this.selfRole);
        return this.stash.unstashAll(CandidateRegistry.create());
    }

    private static String extractRole(Set<String> roles) {
        return roles.stream().filter(role -> !role.contains(DATACENTER_PREFIX)).findFirst().orElseThrow(() -> new IllegalArgumentException("No valid role found."));
    }
}

