/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.eos.akka.registry.listener.owner;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorSystem;
import akka.actor.typed.Behavior;
import akka.actor.typed.javadsl.AbstractBehavior;
import akka.actor.typed.javadsl.ActorContext;
import akka.actor.typed.javadsl.Behaviors;
import akka.actor.typed.javadsl.Receive;
import akka.cluster.ddata.Key;
import akka.cluster.ddata.LWWRegister;
import akka.cluster.ddata.LWWRegisterKey;
import akka.cluster.ddata.typed.javadsl.DistributedData;
import akka.cluster.ddata.typed.javadsl.Replicator;
import akka.cluster.ddata.typed.javadsl.ReplicatorMessageAdapter;
import akka.japi.function.Function;
import java.io.Serializable;
import java.time.Duration;
import org.opendaylight.controller.eos.akka.registry.listener.owner.command.InitialOwnerSync;
import org.opendaylight.controller.eos.akka.registry.listener.owner.command.ListenerCommand;
import org.opendaylight.controller.eos.akka.registry.listener.owner.command.OwnerChanged;
import org.opendaylight.controller.eos.akka.registry.listener.type.command.EntityOwnerChanged;
import org.opendaylight.controller.eos.akka.registry.listener.type.command.TypeListenerCommand;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipStateChange;
import org.opendaylight.mdsal.eos.dom.api.DOMEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleEntityListenerActor
extends AbstractBehavior<ListenerCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(SingleEntityListenerActor.class);
    private final String localMember;
    private final DOMEntity entity;
    private final ActorRef<TypeListenerCommand> toNotify;
    private final ReplicatorMessageAdapter<ListenerCommand, LWWRegister<String>> ownerReplicator;
    private String currentOwner = "";

    public SingleEntityListenerActor(ActorContext<ListenerCommand> context, String localMember, DOMEntity entity, ActorRef<TypeListenerCommand> toNotify) {
        super(context);
        this.localMember = localMember;
        this.entity = entity;
        this.toNotify = toNotify;
        ActorRef replicator = DistributedData.get((ActorSystem)context.getSystem()).replicator();
        this.ownerReplicator = new ReplicatorMessageAdapter(context, replicator, Duration.ofSeconds(5L));
        this.ownerReplicator.askGet(replyTo -> new Replicator.Get((Key)new LWWRegisterKey(entity.toString()), Replicator.readLocal(), replyTo), InitialOwnerSync::new);
        LOG.debug("OwnerListenerActor for {} started", (Object)entity.toString());
    }

    public static Behavior<ListenerCommand> create(String localMember, DOMEntity entity, ActorRef<TypeListenerCommand> toNotify) {
        return Behaviors.setup((Function & Serializable)ctx -> new SingleEntityListenerActor((ActorContext<ListenerCommand>)ctx, localMember, entity, toNotify));
    }

    public Receive<ListenerCommand> createReceive() {
        return this.newReceiveBuilder().onMessage(OwnerChanged.class, this::onOwnerChanged).onMessage(InitialOwnerSync.class, this::onInitialOwnerSync).build();
    }

    private Behavior<ListenerCommand> onInitialOwnerSync(InitialOwnerSync ownerSync) {
        Replicator.GetResponse<LWWRegister<String>> response = ownerSync.getResponse();
        LOG.debug("Received initial sync response for: {}, response: {}", (Object)this.entity, response);
        if (response instanceof Replicator.NotFound) {
            this.triggerNoOwnerNotification();
        } else if (response instanceof Replicator.GetSuccess) {
            LOG.debug("Owner present for entity: {} at the time of initial sync.", (Object)this.entity);
        } else {
            LOG.warn("Get has failed for entity: {}", response);
        }
        this.ownerReplicator.subscribe((Key)new LWWRegisterKey(this.entity.toString()), OwnerChanged::new);
        return this;
    }

    private void triggerNoOwnerNotification() {
        LOG.debug("Triggering initial notification without an owner for: {}", (Object)this.entity);
        this.toNotify.tell((Object)new EntityOwnerChanged(this.entity, EntityOwnershipStateChange.REMOTE_OWNERSHIP_LOST_NO_OWNER, false));
    }

    private Behavior<ListenerCommand> onOwnerChanged(OwnerChanged ownerChanged) {
        Replicator.SubscribeResponse<LWWRegister<String>> response = ownerChanged.getResponse();
        if (response instanceof Replicator.Changed) {
            Replicator.Changed registerChanged = (Replicator.Changed)response;
            LOG.debug("Owner changed for: {}, prevOwner: {}, newOwner: {}", new Object[]{this.entity, this.currentOwner, ((LWWRegister)registerChanged.get(registerChanged.key())).getValue()});
            this.handleOwnerChange((Replicator.Changed<LWWRegister<String>>)registerChanged);
        } else if (response instanceof Replicator.Deleted) {
            this.handleOwnerLost((Replicator.Deleted<LWWRegister<String>>)((Replicator.Deleted)response));
        }
        return this;
    }

    private void handleOwnerChange(Replicator.Changed<LWWRegister<String>> changed) {
        String newOwner = (String)((LWWRegister)changed.get(changed.key())).getValue();
        boolean wasOwner = this.currentOwner.equals(this.localMember);
        boolean isOwner = newOwner.equals(this.localMember);
        boolean hasOwner = !newOwner.equals("");
        LOG.debug("Owner changed for entity:{}, currentOwner: {}, wasOwner: {}, isOwner: {}, hasOwner:{}", new Object[]{this.entity, this.currentOwner, wasOwner, isOwner, hasOwner});
        this.currentOwner = newOwner;
        this.toNotify.tell((Object)new EntityOwnerChanged(this.entity, EntityOwnershipStateChange.from((boolean)wasOwner, (boolean)isOwner, (boolean)hasOwner), false));
    }

    private void handleOwnerLost(Replicator.Deleted<LWWRegister<String>> changed) {
        boolean wasOwner = this.currentOwner.equals(this.localMember);
        LOG.debug("Owner lost for entity:{}, currentOwner: {}, wasOwner: {}", new Object[]{this.entity, this.currentOwner, wasOwner});
        this.currentOwner = "";
        this.toNotify.tell((Object)new EntityOwnerChanged(this.entity, EntityOwnershipStateChange.from((boolean)wasOwner, (boolean)false, (boolean)false), false));
    }
}

