/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.checkerframework.checker.lock.qual.Holding;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.client.AbstractClientConnection;
import org.opendaylight.controller.cluster.access.client.BackendInfo;
import org.opendaylight.controller.cluster.access.client.BackendInfoResolver;
import org.opendaylight.controller.cluster.access.client.ClientActorConfig;
import org.opendaylight.controller.cluster.access.client.ClientActorContext;
import org.opendaylight.controller.cluster.access.client.ConnectedClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectingClientConnection;
import org.opendaylight.controller.cluster.access.client.ConnectionEntry;
import org.opendaylight.controller.cluster.access.client.InternalCommand;
import org.opendaylight.controller.cluster.access.client.InversibleLock;
import org.opendaylight.controller.cluster.access.client.ReconnectForwarder;
import org.opendaylight.controller.cluster.access.client.ReconnectingClientConnection;
import org.opendaylight.controller.cluster.access.client.RecoveredClientActorBehavior;
import org.opendaylight.controller.cluster.access.commands.NotLeaderException;
import org.opendaylight.controller.cluster.access.commands.OutOfSequenceEnvelopeException;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FailureEnvelope;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.RequestException;
import org.opendaylight.controller.cluster.access.concepts.RequestFailure;
import org.opendaylight.controller.cluster.access.concepts.Response;
import org.opendaylight.controller.cluster.access.concepts.ResponseEnvelope;
import org.opendaylight.controller.cluster.access.concepts.RetiredGenerationException;
import org.opendaylight.controller.cluster.access.concepts.RuntimeRequestException;
import org.opendaylight.controller.cluster.access.concepts.SuccessEnvelope;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.common.actor.Dispatchers;
import org.opendaylight.controller.cluster.io.FileBackedOutputStreamFactory;
import org.opendaylight.controller.cluster.messaging.MessageAssembler;
import org.opendaylight.yangtools.concepts.Identifiable;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Registration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.duration.FiniteDuration;

public abstract class ClientActorBehavior<T extends BackendInfo>
extends RecoveredClientActorBehavior<ClientActorContext>
implements Identifiable<ClientIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(ClientActorBehavior.class);
    private static final FiniteDuration RESOLVE_RETRY_DURATION = FiniteDuration.apply((long)1L, (TimeUnit)TimeUnit.SECONDS);
    private final Map<Long, AbstractClientConnection<T>> connections = new ConcurrentHashMap<Long, AbstractClientConnection<T>>();
    private final InversibleLock connectionsLock = new InversibleLock();
    private final BackendInfoResolver<T> resolver;
    private final MessageAssembler responseMessageAssembler;
    private final Registration staleBackendInfoReg;

    protected ClientActorBehavior(@NonNull ClientActorContext context, @NonNull BackendInfoResolver<T> resolver) {
        super(context);
        this.resolver = Objects.requireNonNull(resolver);
        ClientActorConfig config = context.config();
        this.responseMessageAssembler = MessageAssembler.builder().logContext(this.persistenceId()).fileBackedStreamFactory(new FileBackedOutputStreamFactory(config.getFileBackedStreamingThreshold(), config.getTempFileDirectory())).assembledMessageCallback((message, sender) -> context.self().tell(message, sender)).build();
        this.staleBackendInfoReg = resolver.notifyWhenBackendInfoIsStale(shard -> ((ClientActorContext)this.context()).executeInActor(behavior -> {
            LOG.debug("BackendInfo for shard {} is now stale", shard);
            AbstractClientConnection<T> patt0$temp = this.connections.get(shard);
            if (patt0$temp instanceof ConnectedClientConnection) {
                ConnectedClientConnection conn = (ConnectedClientConnection)patt0$temp;
                conn.reconnect(this, new BackendStaleException((Long)shard));
            }
            return behavior;
        }));
    }

    public final ClientIdentifier getIdentifier() {
        return ((ClientActorContext)this.context()).getIdentifier();
    }

    @Override
    public void close() {
        super.close();
        this.responseMessageAssembler.close();
        this.staleBackendInfoReg.close();
    }

    public final AbstractClientConnection<T> getConnection(Long shard) {
        AbstractClientConnection conn;
        long stamp;
        do {
            stamp = this.connectionsLock.optimisticRead();
            conn = this.connections.computeIfAbsent(shard, this::createConnection);
        } while (!this.connectionsLock.validate(stamp));
        return conn;
    }

    private AbstractClientConnection<T> getConnection(ResponseEnvelope<?> response) {
        return this.connections.get(ClientActorBehavior.extractCookie((Identifier)((Response)response.getMessage()).getTarget()));
    }

    @Override
    final ClientActorBehavior<T> onReceiveCommand(Object command) {
        if (command instanceof InternalCommand) {
            return ((InternalCommand)command).execute(this);
        }
        if (command instanceof SuccessEnvelope) {
            SuccessEnvelope successEnvelope = (SuccessEnvelope)command;
            return this.onRequestSuccess(successEnvelope);
        }
        if (command instanceof FailureEnvelope) {
            FailureEnvelope failureEnvelope = (FailureEnvelope)command;
            return this.internalOnRequestFailure(failureEnvelope);
        }
        if (MessageAssembler.isHandledMessage((Object)command)) {
            ((ClientActorContext)this.context()).dispatchers().getDispatcher(Dispatchers.DispatcherType.Serialization).execute(() -> this.responseMessageAssembler.handleMessage(command, ((ClientActorContext)this.context()).self()));
            return this;
        }
        if (((ClientActorContext)this.context()).messageSlicer().handleMessage(command)) {
            return this;
        }
        return this.onCommand(command);
    }

    private static long extractCookie(Identifier id) {
        Identifier identifier = id;
        Objects.requireNonNull(identifier);
        Identifier identifier2 = identifier;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TransactionIdentifier.class, LocalHistoryIdentifier.class}, (Object)identifier2, n)) {
            case 0 -> {
                TransactionIdentifier transactionId = (TransactionIdentifier)identifier2;
                yield transactionId.getHistoryId().getCookie();
            }
            case 1 -> {
                LocalHistoryIdentifier historyId = (LocalHistoryIdentifier)identifier2;
                yield historyId.getCookie();
            }
            default -> throw new IllegalArgumentException("Unhandled identifier " + String.valueOf(id));
        };
    }

    private void onResponse(ResponseEnvelope<?> response) {
        AbstractClientConnection<T> connection = this.getConnection(response);
        if (connection != null) {
            connection.receiveResponse(response);
        } else {
            LOG.info("{}: Ignoring unknown response {}", (Object)this.persistenceId(), response);
        }
    }

    private ClientActorBehavior<T> onRequestSuccess(SuccessEnvelope success) {
        this.onResponse((ResponseEnvelope<?>)success);
        return this;
    }

    private ClientActorBehavior<T> onRequestFailure(FailureEnvelope failure) {
        this.onResponse((ResponseEnvelope<?>)failure);
        return this;
    }

    private ClientActorBehavior<T> internalOnRequestFailure(FailureEnvelope command) {
        Optional<T> optBackend;
        AbstractClientConnection<T> conn = this.getConnection((ResponseEnvelope<?>)command);
        if (conn != null && (optBackend = conn.getBackendInfo()).isPresent() && ((BackendInfo)optBackend.orElseThrow()).getSessionId() != command.getSessionId()) {
            LOG.debug("{}: Mismatched current connection {} and envelope {}, ignoring response", new Object[]{this.persistenceId(), conn, command});
            return this;
        }
        RequestFailure failure = (RequestFailure)command.getMessage();
        RequestException cause = failure.getCause();
        if (cause instanceof RetiredGenerationException) {
            LOG.error("{}: current generation {} has been superseded", new Object[]{this.persistenceId(), this.getIdentifier(), cause});
            this.haltClient((Throwable)cause);
            this.poison(cause);
            return null;
        }
        if (cause instanceof NotLeaderException) {
            if (conn instanceof ReconnectingClientConnection) {
                return this;
            }
            if (conn != null) {
                LOG.info("{}: connection {} indicated no leadership, reconnecting it", new Object[]{this.persistenceId(), conn, cause});
                return conn.reconnect(this, cause);
            }
        }
        if (cause instanceof OutOfSequenceEnvelopeException) {
            if (conn instanceof ReconnectingClientConnection) {
                return this;
            }
            if (conn != null) {
                LOG.info("{}: connection {} indicated sequencing mismatch on {} sequence {} ({}), reconnecting it", new Object[]{this.persistenceId(), conn, failure.getTarget(), failure.getSequence(), command.getTxSequence(), cause});
                return conn.reconnect(this, cause);
            }
        }
        return this.onRequestFailure(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poison(RequestException cause) {
        long stamp = this.connectionsLock.writeLock();
        try {
            for (AbstractClientConnection<T> q : this.connections.values()) {
                q.poison(cause);
            }
            this.connections.clear();
        }
        finally {
            this.connectionsLock.unlockWrite(stamp);
        }
        ((ClientActorContext)this.context()).messageSlicer().close();
    }

    protected abstract void haltClient(@NonNull Throwable var1);

    protected abstract @Nullable ClientActorBehavior<T> onCommand(@NonNull Object var1);

    protected final @NonNull BackendInfoResolver<T> resolver() {
        return this.resolver;
    }

    @Holding(value={"connectionsLock"})
    protected abstract @NonNull ConnectionConnectCohort connectionUp(@NonNull ConnectedClientConnection<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backendConnectFinished(Long shard, AbstractClientConnection<T> oldConn, T backend, Throwable failure) {
        if (failure != null) {
            RequestException requestException;
            if (failure instanceof TimeoutException) {
                if (!oldConn.equals(this.connections.get(shard))) {
                    LOG.info("{}: stopping resolution of shard {} on stale connection {}", new Object[]{this.persistenceId(), shard, oldConn, failure});
                    return;
                }
                LOG.debug("{}: timed out resolving shard {}, scheduling retry in {}", new Object[]{this.persistenceId(), shard, RESOLVE_RETRY_DURATION, failure});
                ((ClientActorContext)this.context()).executeInActor(b -> {
                    this.resolveConnection(shard, oldConn);
                    return b;
                }, RESOLVE_RETRY_DURATION);
                return;
            }
            LOG.error("{}: failed to resolve shard {}", new Object[]{this.persistenceId(), shard, failure});
            Object cause = failure instanceof RequestException ? (requestException = (RequestException)failure) : new RuntimeRequestException("Failed to resolve shard " + shard, failure);
            oldConn.poison((RequestException)cause);
            return;
        }
        LOG.info("{}: resolved shard {} to {}", new Object[]{this.persistenceId(), shard, backend});
        long stamp = this.connectionsLock.writeLock();
        try {
            Stopwatch sw = Stopwatch.createStarted();
            ConnectedClientConnection<T> newConn = new ConnectedClientConnection<T>(oldConn, backend);
            LOG.info("{}: resolving connection {} to {}", new Object[]{this.persistenceId(), oldConn, newConn});
            ConnectionConnectCohort cohort = (ConnectionConnectCohort)Verify.verifyNotNull((Object)this.connectionUp(newConn));
            Collection<ConnectionEntry> replayIterable = oldConn.startReplay();
            ReconnectForwarder forwarder = (ReconnectForwarder)Verify.verifyNotNull((Object)cohort.finishReconnect(replayIterable));
            newConn.cancelDebt();
            oldConn.finishReplay(forwarder);
            if (!this.connections.replace(shard, oldConn, newConn)) {
                AbstractClientConnection<T> existing = this.connections.get(oldConn.cookie());
                LOG.warn("{}: old connection {} does not match existing {}, new connection {} in limbo", new Object[]{this.persistenceId(), oldConn, existing, newConn});
            } else {
                LOG.info("{}: replaced connection {} with {} in {}", new Object[]{this.persistenceId(), oldConn, newConn, sw});
            }
        }
        finally {
            this.connectionsLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(AbstractClientConnection<?> conn) {
        long stamp = this.connectionsLock.writeLock();
        try {
            if (!this.connections.remove(conn.cookie(), conn)) {
                AbstractClientConnection<T> existing = this.connections.get(conn.cookie());
                if (existing != null) {
                    LOG.warn("{}: failed to remove connection {}, as it was superseded by {}", new Object[]{this.persistenceId(), conn, existing});
                } else {
                    LOG.warn("{}: failed to remove connection {}, as it was not tracked", (Object)this.persistenceId(), conn);
                }
            } else {
                LOG.info("{}: removed connection {}", (Object)this.persistenceId(), conn);
                this.cancelSlicing(conn.cookie());
            }
        }
        finally {
            this.connectionsLock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnectConnection(ConnectedClientConnection<?> oldConn, ReconnectingClientConnection<?> newConn) {
        ReconnectingClientConnection<?> conn = newConn;
        LOG.info("{}: connection {} reconnecting as {}", new Object[]{this.persistenceId(), oldConn, newConn});
        long stamp = this.connectionsLock.writeLock();
        try {
            boolean replaced = this.connections.replace(oldConn.cookie(), oldConn, conn);
            if (!replaced) {
                AbstractClientConnection<T> existing = this.connections.get(oldConn.cookie());
                if (existing != null) {
                    LOG.warn("{}: failed to replace connection {}, as it was superseded by {}", new Object[]{this.persistenceId(), conn, existing});
                } else {
                    LOG.warn("{}: failed to replace connection {}, as it was not tracked", (Object)this.persistenceId(), conn);
                }
            } else {
                this.cancelSlicing(oldConn.cookie());
            }
        }
        finally {
            this.connectionsLock.unlockWrite(stamp);
        }
        Long shard = oldConn.cookie();
        LOG.info("{}: refreshing backend for shard {}", (Object)this.persistenceId(), (Object)shard);
        this.resolver().refreshBackendInfo(shard, (BackendInfo)conn.getBackendInfo().orElseThrow()).whenComplete((backend, failure) -> ((ClientActorContext)this.context()).executeInActor(behavior -> {
            this.backendConnectFinished(shard, conn, (T)backend, (Throwable)failure);
            return behavior;
        }));
    }

    private void cancelSlicing(Long cookie) {
        ((ClientActorContext)this.context()).messageSlicer().cancelSlicing(id -> {
            try {
                return cookie.equals(ClientActorBehavior.extractCookie(id));
            }
            catch (IllegalArgumentException e) {
                LOG.debug("extractCookie failed while cancelling slicing for cookie {}", (Object)cookie, (Object)e);
                return false;
            }
        });
    }

    private ConnectingClientConnection<T> createConnection(Long shard) {
        ConnectingClientConnection conn = new ConnectingClientConnection((ClientActorContext)this.context(), shard, this.resolver().resolveCookieName(shard));
        this.resolveConnection(shard, conn);
        return conn;
    }

    private void resolveConnection(Long shard, AbstractClientConnection<T> conn) {
        LOG.debug("{}: resolving shard {} connection {}", new Object[]{this.persistenceId(), shard, conn});
        this.resolver().getBackendInfo(shard).whenComplete((backend, failure) -> ((ClientActorContext)this.context()).executeInActor(behavior -> {
            this.backendConnectFinished(shard, conn, (T)backend, (Throwable)failure);
            return behavior;
        }));
    }

    @FunctionalInterface
    protected static interface ConnectionConnectCohort {
        public @NonNull ReconnectForwarder finishReconnect(@NonNull Collection<ConnectionEntry> var1);
    }

    private static class BackendStaleException
    extends RequestException {
        private static final long serialVersionUID = 1L;

        BackendStaleException(Long shard) {
            super("Backend for shard " + shard + " is stale");
        }

        public boolean isRetriable() {
            return false;
        }
    }
}

