/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.StampedLock;
import org.opendaylight.controller.cluster.access.client.InversibleLockException;

public final class InversibleLock {
    private static final VarHandle LATCH;
    private final StampedLock lock = new StampedLock();
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="https://github.com/spotbugs/spotbugs/issues/2749")
    private volatile CountDownLatch latch;

    public long optimisticRead() {
        CountDownLatch local;
        do {
            long stamp;
            if ((stamp = this.lock.tryOptimisticRead()) == 0L) continue;
            return stamp;
        } while ((local = this.latch) == null);
        throw new InversibleLockException(local);
    }

    public boolean validate(long stamp) {
        return this.lock.validate(stamp);
    }

    public long writeLock() {
        Verify.verify((boolean)LATCH.compareAndSet(this, null, new CountDownLatch(1)));
        return this.lock.writeLock();
    }

    public void unlockWrite(long stamp) {
        CountDownLatch local = (CountDownLatch)Verify.verifyNotNull((Object)LATCH.getAndSet(this, null));
        this.lock.unlockWrite(stamp);
        local.countDown();
    }

    static {
        try {
            LATCH = MethodHandles.lookup().findVarHandle(InversibleLock.class, "latch", CountDownLatch.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

