/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.client;

import java.util.Objects;
import java.util.concurrent.CountDownLatch;

public final class InversibleLockException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final transient CountDownLatch latch;

    InversibleLockException(CountDownLatch latch) {
        this.latch = Objects.requireNonNull(latch);
    }

    public void awaitResolution() {
        if (this.latch != null) {
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Interrupted while waiting for latch " + String.valueOf(this.latch), e);
            }
        }
    }
}

