/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.spi.node.CloneableMap;

final class UnmodifiableChildrenMap
implements CloneableMap<YangInstanceIdentifier.PathArgument, DataContainerChild>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int WRAP_THRESHOLD = 9;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Delegate is expected to be Serializable")
    private final Map<YangInstanceIdentifier.PathArgument, DataContainerChild> delegate;
    private transient Collection<DataContainerChild> values = null;

    private UnmodifiableChildrenMap(Map<YangInstanceIdentifier.PathArgument, DataContainerChild> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    static Map<YangInstanceIdentifier.PathArgument, DataContainerChild> create(Map<YangInstanceIdentifier.PathArgument, DataContainerChild> map) {
        if (map instanceof UnmodifiableChildrenMap || map instanceof ImmutableMap) {
            return map;
        }
        if (map.isEmpty()) {
            return ImmutableMap.of();
        }
        if (map.size() < 9) {
            return ImmutableMap.copyOf(map);
        }
        return new UnmodifiableChildrenMap(map);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public DataContainerChild get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public DataContainerChild put(YangInstanceIdentifier.PathArgument key, DataContainerChild value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataContainerChild remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends YangInstanceIdentifier.PathArgument, ? extends DataContainerChild> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<YangInstanceIdentifier.PathArgument> keySet() {
        return Collections.unmodifiableSet(this.delegate.keySet());
    }

    @Override
    public Collection<DataContainerChild> values() {
        if (this.values == null) {
            this.values = Collections.unmodifiableCollection(this.delegate.values());
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<YangInstanceIdentifier.PathArgument, DataContainerChild>> entrySet() {
        return Collections.unmodifiableMap(this.delegate).entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Map<YangInstanceIdentifier.PathArgument, DataContainerChild> createMutableClone() {
        Map<YangInstanceIdentifier.PathArgument, DataContainerChild> map = this.delegate;
        if (map instanceof HashMap) {
            HashMap hashMap = (HashMap)map;
            return (Map)hashMap.clone();
        }
        return new HashMap<YangInstanceIdentifier.PathArgument, DataContainerChild>(this.delegate);
    }
}

