/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AbstractLeafSetEntryNode;

public abstract sealed class ImmutableLeafSetEntryNode<T>
extends AbstractLeafSetEntryNode<T> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeWithValue<T> name;

    private ImmutableLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<T> name) {
        this.name = Objects.requireNonNull(name);
    }

    public static <T> @NonNull ImmutableLeafSetEntryNode<T> of(YangInstanceIdentifier.NodeWithValue<T> name) {
        ImmutableLeafSetEntryNode immutableLeafSetEntryNode;
        Object object = name.getValue();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{byte[].class, YangInstanceIdentifier.class}, (Object)object2, n)) {
                case 0: {
                    byte[] bytes = (byte[])object2;
                    Binary ret = new Binary((YangInstanceIdentifier.NodeWithValue<byte[]>)name);
                    immutableLeafSetEntryNode = ret;
                    break block4;
                }
                case 1: {
                    YangInstanceIdentifier yiid = (YangInstanceIdentifier)object2;
                    if (!yiid.isEmpty()) {
                        n = 2;
                        continue block4;
                    }
                    throw new IllegalArgumentException("Leafset entry node value cannot be an empty instance identifier");
                }
                default: {
                    immutableLeafSetEntryNode = new Regular<T>(name);
                    break block4;
                }
            }
            break;
        }
        return immutableLeafSetEntryNode;
    }

    public static <T> @NonNull ImmutableLeafSetEntryNode<T> of(YangInstanceIdentifier.NodeWithValue<T> name, T body) {
        Object nameValue = name.getValue();
        if (body instanceof byte[]) {
            byte[] nameBytes;
            byte[] bodyBytes = (byte[])body;
            if (nameValue instanceof byte[] && Arrays.equals(nameBytes = (byte[])nameValue, bodyBytes)) {
                Binary ret = new Binary((YangInstanceIdentifier.NodeWithValue<byte[]>)name);
                return ret;
            }
        } else {
            YangInstanceIdentifier yiid;
            if (nameValue instanceof YangInstanceIdentifier && (yiid = (YangInstanceIdentifier)nameValue).isEmpty()) {
                throw new IllegalArgumentException("Leafset entry node value cannot be an empty instance identifier");
            }
            if (nameValue.equals(body)) {
                return new Regular<T>(name);
            }
        }
        throw new IllegalArgumentException("Node identifier contains different value: " + String.valueOf(name) + " than value itself: " + String.valueOf(body));
    }

    public final YangInstanceIdentifier.NodeWithValue<T> name() {
        return this.name;
    }

    protected final T value() {
        return (T)this.name.getValue();
    }

    protected final Class<?> toStringClass() {
        return ImmutableLeafSetEntryNode.class;
    }

    private static final class Binary
    extends ImmutableLeafSetEntryNode<byte[]> {
        Binary(YangInstanceIdentifier.NodeWithValue<byte[]> name) {
            super(name);
        }

        protected byte[] wrappedValue() {
            return (byte[])((byte[])this.value()).clone();
        }
    }

    private static final class Regular<T>
    extends ImmutableLeafSetEntryNode<T> {
        Regular(YangInstanceIdentifier.NodeWithValue<T> name) {
            super(name);
        }

        protected T wrappedValue() {
            return this.value();
        }
    }
}

