/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.UnmodifiableCollection;
import org.opendaylight.yangtools.util.UnmodifiableMap;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AbstractUserMapNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserMapNode;

final class ImmutableUserMapNode
extends AbstractUserMapNode {
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifier name;
    final @NonNull Map<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children;

    ImmutableUserMapNode(YangInstanceIdentifier.NodeIdentifier name, Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> children) {
        this.name = Objects.requireNonNull(name);
        this.children = Objects.requireNonNull(children);
    }

    public YangInstanceIdentifier.NodeIdentifier name() {
        return this.name;
    }

    public MapEntryNode childByArg(YangInstanceIdentifier.NodeIdentifierWithPredicates child) {
        return this.children.get(child);
    }

    public MapEntryNode childAt(int position) {
        return (MapEntryNode)Iterables.get(this.children.values(), (int)position);
    }

    public int size() {
        return this.children.size();
    }

    public Collection<MapEntryNode> value() {
        return this.children.values();
    }

    public Collection<MapEntryNode> wrappedValue() {
        return UnmodifiableCollection.create((Collection)this.value());
    }

    public Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> asMap() {
        return UnmodifiableMap.of(this.children);
    }

    protected int valueHashCode() {
        int hashCode = 1;
        for (MapEntryNode child : this.children.values()) {
            hashCode = 31 * hashCode + child.hashCode();
        }
        return hashCode;
    }

    protected boolean valueEquals(UserMapNode other) {
        Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> map;
        if (other instanceof ImmutableUserMapNode) {
            ImmutableUserMapNode immutable = (ImmutableUserMapNode)other;
            map = immutable.children;
        } else {
            map = other.asMap();
        }
        Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> otherChildren = map;
        return Iterables.elementsEqual(this.children.values(), otherChildren.values());
    }
}

