/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UserMapNode;
import org.opendaylight.yangtools.yang.data.spi.node.impl.ImmutableUserMapNode;

public final class ImmutableUserMapNodeBuilder
implements UserMapNode.Builder {
    private static final int DEFAULT_CAPACITY = 4;
    private Map<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode> value;
    private YangInstanceIdentifier.NodeIdentifier nodeIdentifier;
    private boolean dirty;

    public ImmutableUserMapNodeBuilder() {
        this.value = new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
        this.dirty = false;
    }

    public ImmutableUserMapNodeBuilder(int sizeHint) {
        this.value = sizeHint >= 0 ? new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(sizeHint + sizeHint / 3) : new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(4);
        this.dirty = false;
    }

    private ImmutableUserMapNodeBuilder(ImmutableUserMapNode node) {
        this.nodeIdentifier = node.name();
        this.value = node.children;
        this.dirty = true;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull UserMapNode.Builder create(UserMapNode node) {
        if (node instanceof ImmutableUserMapNode) {
            ImmutableUserMapNode immutableNode = (ImmutableUserMapNode)node;
            return new ImmutableUserMapNodeBuilder(immutableNode);
        }
        throw new UnsupportedOperationException("Cannot initialize from class " + String.valueOf(node.getClass()));
    }

    private void checkDirty() {
        if (this.dirty) {
            this.value = new LinkedHashMap<YangInstanceIdentifier.NodeIdentifierWithPredicates, MapEntryNode>(this.value);
            this.dirty = false;
        }
    }

    public ImmutableUserMapNodeBuilder withChild(MapEntryNode child) {
        this.checkDirty();
        this.value.put(child.name(), child);
        return this;
    }

    public ImmutableUserMapNodeBuilder withoutChild(YangInstanceIdentifier.PathArgument key) {
        this.checkDirty();
        this.value.remove(key);
        return this;
    }

    public ImmutableUserMapNodeBuilder withValue(Collection<MapEntryNode> withValue) {
        for (MapEntryNode mapEntryNode : withValue) {
            this.withChild(mapEntryNode);
        }
        return this;
    }

    public ImmutableUserMapNodeBuilder withNodeIdentifier(YangInstanceIdentifier.NodeIdentifier withNodeIdentifier) {
        this.nodeIdentifier = withNodeIdentifier;
        return this;
    }

    public ImmutableUserMapNodeBuilder addChild(MapEntryNode child) {
        return this.withChild(child);
    }

    public ImmutableUserMapNodeBuilder removeChild(YangInstanceIdentifier.PathArgument key) {
        return this.withoutChild(key);
    }

    public UserMapNode build() {
        this.dirty = true;
        return new ImmutableUserMapNode(this.nodeIdentifier, this.value);
    }
}

