/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl;

import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.Generator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GeneratorReactor;
import org.opendaylight.yangtools.binding.generator.impl.reactor.IdentityGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultBindingRuntimeTypes;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.yangtools.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.IdentityRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ModuleRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BindingRuntimeTypesFactory
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(BindingRuntimeTypesFactory.class);
    private final Map<QNameModule, ModuleRuntimeType> modules = new HashMap<QNameModule, ModuleRuntimeType>();
    private final Map<QName, IdentityRuntimeType> identities = new HashMap<QName, IdentityRuntimeType>();
    private final Map<JavaTypeName, RuntimeType> allTypes = new HashMap<JavaTypeName, RuntimeType>();
    private final SetMultimap<JavaTypeName, CaseRuntimeType> choiceToCases = HashMultimap.create();

    private BindingRuntimeTypesFactory() {
    }

    static @NonNull BindingRuntimeTypes createTypes(@NonNull EffectiveModelContext modelContext) {
        Map<QNameModule, ModuleGenerator> moduleGens = new GeneratorReactor(modelContext).execute(TypeBuilderFactory.runtime());
        Stopwatch sw = Stopwatch.createStarted();
        BindingRuntimeTypesFactory factory = new BindingRuntimeTypesFactory();
        factory.indexModules(moduleGens);
        LOG.debug("Indexed {} generators in {}", (Object)moduleGens.size(), (Object)sw);
        return new DefaultBindingRuntimeTypes(modelContext, factory.modules, factory.allTypes, factory.identities, factory.choiceToCases);
    }

    private void indexModules(Map<QNameModule, ModuleGenerator> moduleGens) {
        for (Map.Entry<QNameModule, ModuleGenerator> entry : moduleGens.entrySet()) {
            ModuleGenerator modGen = entry.getValue();
            BindingRuntimeTypesFactory.safePut(this.modules, "modules", entry.getKey(), (ModuleRuntimeType)modGen.getRuntimeType());
            for (Generator gen : modGen) {
                if (!(gen instanceof IdentityGenerator)) continue;
                IdentityGenerator idGen = (IdentityGenerator)gen;
                BindingRuntimeTypesFactory.safePut(this.identities, "identities", (QName)((IdentityEffectiveStatement)idGen.statement()).argument(), (IdentityRuntimeType)idGen.getRuntimeType());
            }
        }
        this.indexRuntimeTypes(moduleGens.values());
    }

    private void indexRuntimeTypes(Iterable<? extends Generator> generators) {
        for (Generator generator : generators) {
            Type type;
            AbstractExplicitGenerator explicit;
            Object type2;
            if (generator instanceof AbstractExplicitGenerator && (type2 = (explicit = (AbstractExplicitGenerator)generator).generatedRuntimeType()) != null && (type = type2.javaType()) instanceof GeneratedType) {
                GeneratedType genType = (GeneratedType)type;
                JavaTypeName name = (JavaTypeName)genType.getIdentifier();
                RuntimeType prev = this.allTypes.put(name, (RuntimeType)type2);
                Verify.verify((prev == null || prev == type2 ? 1 : 0) != 0, (String)"Conflict on runtime type mapping of %s between %s and %s", (Object)name, (Object)prev, type2);
                if (type2 instanceof CaseRuntimeType) {
                    CaseRuntimeType caseType = (CaseRuntimeType)type2;
                    List ifaces = genType.getImplements();
                    Verify.verify((ifaces.size() >= 2 ? 1 : 0) != 0, (String)"Unexpected implemented interfaces %s", (Object)ifaces);
                    this.choiceToCases.put((Object)((JavaTypeName)((Type)ifaces.get(0)).getIdentifier()), (Object)caseType);
                }
            }
            this.indexRuntimeTypes(generator);
        }
    }

    private static <K, V> void safePut(Map<K, V> map, String name, K key, V value) {
        V prev = map.put(key, value);
        Verify.verify((prev == null ? 1 : 0) != 0, (String)"Conflict in %s, key %s conflicts on %s versus %s", (Object)name, key, prev, value);
    }
}

