/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import java.util.List;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultNotificationRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.NotificationRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

abstract class AbstractNotificationGenerator
extends CompositeSchemaTreeGenerator<NotificationEffectiveStatement, NotificationRuntimeType> {
    AbstractNotificationGenerator(NotificationEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    final StatementNamespace namespace() {
        return StatementNamespace.NOTIFICATION;
    }

    @Override
    final void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterSchemaTree((QName)((NotificationEffectiveStatement)this.statement()).argument());
    }

    @Override
    ClassPlacement classPlacement() {
        return ClassPlacement.TOP_LEVEL;
    }

    @Override
    final GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.DATA_OBJECT);
        builder.addImplementsType(this.notificationType(builder, builderFactory));
        AbstractExplicitGenerator orig = this.getOriginal();
        if (this.equals(orig)) {
            this.addUsesInterfaces(builder, builderFactory);
            this.addGetterMethods(builder, builderFactory);
        } else {
            builder.addImplementsType((Type)orig.getGeneratedType(builderFactory));
        }
        AbstractNotificationGenerator.addAugmentable(builder);
        AbstractNotificationGenerator.addConcreteInterfaceMethods(builder);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        return builder.build();
    }

    @Override
    final void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }

    @Override
    final CompositeRuntimeTypeBuilder<NotificationEffectiveStatement, NotificationRuntimeType> createBuilder(NotificationEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<NotificationEffectiveStatement, NotificationRuntimeType>(this, statement){

            @Override
            NotificationRuntimeType build(GeneratedType type, NotificationEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                return new DefaultNotificationRuntimeType(type, statement, children, augments);
            }
        };
    }

    abstract Type notificationType(GeneratedTypeBuilder var1, TypeBuilderFactory var2);
}

