/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import java.util.List;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractInvokableGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.InvokableRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.KeyGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ListGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultActionRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.model.ri.Types;
import org.opendaylight.yangtools.binding.runtime.api.ActionRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;

final class ActionGenerator
extends AbstractInvokableGenerator<ActionEffectiveStatement, ActionRuntimeType> {
    ActionGenerator(ActionEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.ACTION;
    }

    @Override
    ClassPlacement classPlacement() {
        return this.getParent() instanceof GroupingGenerator ? ClassPlacement.PHANTOM : ClassPlacement.TOP_LEVEL;
    }

    @Override
    void addImplementedType(TypeBuilderFactory builderFactory, GeneratedTypeBuilder builder, GeneratedType input, GeneratedType output) {
        ListGenerator list;
        KeyGenerator keyGen;
        AbstractCompositeGenerator<?, ?> parent = this.getParent();
        Type parentType = Type.of((JavaTypeName)parent.typeName());
        if (parent instanceof ListGenerator && (keyGen = (list = (ListGenerator)parent).keyGenerator()) != null) {
            GeneratedType keyType = keyGen.getGeneratedType(builderFactory);
            builder.addImplementsType((Type)BindingTypes.keyedListAction((Type)parentType, (Type)keyType, (Type)input, (Type)output));
            ((MethodSignatureBuilder)builder.addMethod("invoke").setAbstract(true).addParameter((Type)BindingTypes.objectIdentifierWithKey((Type)parentType, (Type)keyType), "path").addParameter((Type)input, "input").setReturnType((Type)Types.listenableFutureTypeFor((Type)BindingTypes.rpcResult((Type)output)))).addAnnotation(OVERRIDE_ANNOTATION);
            return;
        }
        builder.addImplementsType((Type)BindingTypes.action((Type)parentType, (Type)input, (Type)output));
        ((MethodSignatureBuilder)builder.addMethod("invoke").setAbstract(true).addParameter((Type)BindingTypes.objectIdentifier((Type)parentType), "path").addParameter((Type)input, "input").setReturnType((Type)Types.listenableFutureTypeFor((Type)BindingTypes.rpcResult((Type)output)))).addAnnotation(OVERRIDE_ANNOTATION);
    }

    @Override
    CompositeRuntimeTypeBuilder<ActionEffectiveStatement, ActionRuntimeType> createBuilder(ActionEffectiveStatement statement) {
        return new InvokableRuntimeTypeBuilder<ActionEffectiveStatement, ActionRuntimeType>(this, statement){

            @Override
            ActionRuntimeType build(GeneratedType generatedType, ActionEffectiveStatement statement, List<RuntimeType> childTypes) {
                return new DefaultActionRuntimeType(generatedType, statement, childTypes);
            }
        };
    }
}

