/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractTypeAwareGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultLeafListRuntimeType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.ri.Types;
import org.opendaylight.yangtools.binding.runtime.api.LeafListRuntimeType;
import org.opendaylight.yangtools.yang.common.Ordering;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;

final class LeafListGenerator
extends AbstractTypeAwareGenerator<LeafListEffectiveStatement, LeafListRuntimeType, LeafListGenerator> {
    LeafListGenerator(LeafListEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.LEAF_LIST;
    }

    @Override
    Type methodReturnType(TypeBuilderFactory builderFactory) {
        Type type = super.methodReturnType(builderFactory);
        boolean isObject = Types.objectType().equals((Object)type);
        if (((LeafListEffectiveStatement)this.statement()).ordering() == Ordering.SYSTEM) {
            return isObject ? Types.setTypeWildcard() : Types.setTypeFor((Type)type);
        }
        return isObject ? Types.listTypeWildcard() : Types.listTypeFor((Type)type);
    }

    @Override
    LeafListRuntimeType createExternalRuntimeType(Type type) {
        return new DefaultLeafListRuntimeType(type, (LeafListEffectiveStatement)this.statement());
    }

    @Override
    LeafListRuntimeType createInternalRuntimeType(AugmentResolver resolver, LeafListEffectiveStatement statement, Type type) {
        return new DefaultLeafListRuntimeType(type, statement);
    }
}

