/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CamelCaseNamingStrategy;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ClassNamingStrategy;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.reactor.YangDataNamingStrategy;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultYangDataRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.YangDataRuntimeType;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

abstract sealed class YangDataGenerator
extends AbstractCompositeGenerator<YangDataEffectiveStatement, YangDataRuntimeType> {
    private YangDataGenerator(YangDataEffectiveStatement statement, ModuleGenerator parent) {
        super(statement, parent);
    }

    static @NonNull YangDataGenerator of(YangDataEffectiveStatement statement, ModuleGenerator parent) {
        String templateName = ((YangDataName)statement.argument()).name();
        UnresolvedQName.Unqualified identifier = UnresolvedQName.tryLocalName((String)templateName);
        return identifier != null ? new WithIdentifier(statement, parent, identifier) : new WithString(statement, parent);
    }

    @Override
    final void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterYangData((YangDataName)((YangDataEffectiveStatement)this.statement()).argument());
    }

    @Override
    final ClassPlacement classPlacement() {
        return ClassPlacement.TOP_LEVEL;
    }

    @Override
    final CollisionDomain.Member createMember(CollisionDomain domain) {
        return domain.addPrimary(this, this.createNamingStrategy());
    }

    abstract @NonNull ClassNamingStrategy createNamingStrategy();

    @Override
    final StatementNamespace namespace() {
        return StatementNamespace.YANG_DATA;
    }

    @Override
    final GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.yangData((Type)builder));
        this.addUsesInterfaces(builder, builderFactory);
        YangDataGenerator.addConcreteInterfaceMethods(builder);
        this.addGetterMethods(builder, builderFactory);
        ModuleGenerator module = this.currentModule();
        module.addNameConstant((GeneratedTypeBuilderBase<?>)builder, (YangDataName)((YangDataEffectiveStatement)this.statement()).argument());
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        return builder.build();
    }

    @Override
    final CompositeRuntimeTypeBuilder<YangDataEffectiveStatement, YangDataRuntimeType> createBuilder(YangDataEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<YangDataEffectiveStatement, YangDataRuntimeType>(this, statement){

            @Override
            YangDataRuntimeType build(GeneratedType type, YangDataEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                return new DefaultYangDataRuntimeType(type, statement, children);
            }
        };
    }

    @Override
    final void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }

    private static final class WithIdentifier
    extends YangDataGenerator {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull UnresolvedQName.Unqualified identifier;

        WithIdentifier(YangDataEffectiveStatement statement, ModuleGenerator parent, UnresolvedQName.Unqualified identifier) {
            super(statement, parent);
            this.identifier = Objects.requireNonNull(identifier);
        }

        @Override
        CamelCaseNamingStrategy createNamingStrategy() {
            return new CamelCaseNamingStrategy(this.namespace(), (AbstractQName)this.identifier);
        }
    }

    private static final class WithString
    extends YangDataGenerator {
        WithString(YangDataEffectiveStatement statement, ModuleGenerator parent) {
            super(statement, parent);
        }

        @Override
        YangDataNamingStrategy createNamingStrategy() {
            return new YangDataNamingStrategy((YangDataName)((YangDataEffectiveStatement)this.statement()).argument());
        }
    }
}

