/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.rt;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.yangtools.binding.runtime.api.CaseRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ChoiceRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.GeneratedRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.IdentityRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ModuleRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.YangDataRuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

public final class DefaultBindingRuntimeTypes
implements BindingRuntimeTypes {
    private final @NonNull EffectiveModelContext modelContext;
    private final ImmutableSetMultimap<JavaTypeName, CaseRuntimeType> choiceToCases;
    private final ImmutableMap<QNameModule, ModuleRuntimeType> modulesByNamespace;
    private final ImmutableSortedMap<String, ModuleRuntimeType> modulesByPackage;
    private final ImmutableMap<QName, IdentityRuntimeType> identities;
    private final ImmutableMap<JavaTypeName, RuntimeType> types;

    public DefaultBindingRuntimeTypes(EffectiveModelContext modelContext, Map<QNameModule, ModuleRuntimeType> modules, Map<JavaTypeName, RuntimeType> types, Map<QName, IdentityRuntimeType> identities, SetMultimap<JavaTypeName, CaseRuntimeType> choiceToCases) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.identities = ImmutableMap.copyOf(identities);
        this.types = ImmutableMap.copyOf(types);
        this.choiceToCases = ImmutableSetMultimap.copyOf(choiceToCases);
        this.modulesByNamespace = ImmutableMap.copyOf(modules);
        this.modulesByPackage = ImmutableSortedMap.copyOf((Map)Maps.uniqueIndex(modules.values(), module -> module.getIdentifier().packageName()));
    }

    public EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    public IdentityRuntimeType identityChild(QName qname) {
        return (IdentityRuntimeType)this.identities.get((Object)Objects.requireNonNull(qname));
    }

    public Optional<RuntimeType> findSchema(JavaTypeName typeName) {
        return Optional.ofNullable((RuntimeType)this.types.get((Object)Objects.requireNonNull(typeName)));
    }

    public GeneratedRuntimeType bindingChild(JavaTypeName typeName) {
        Map.Entry entry = this.modulesByPackage.floorEntry((Object)typeName.packageName());
        return entry == null ? null : ((ModuleRuntimeType)entry.getValue()).bindingChild(typeName);
    }

    public RuntimeType schemaTreeChild(QName qname) {
        ModuleRuntimeType module = (ModuleRuntimeType)this.modulesByNamespace.get((Object)qname.getModule());
        return module == null ? null : module.schemaTreeChild(qname);
    }

    public Optional<ModuleRuntimeType> findModule(QNameModule module) {
        return Optional.ofNullable((ModuleRuntimeType)this.modulesByNamespace.get((Object)module));
    }

    public Optional<YangDataRuntimeType> findYangData(YangDataName templateName) {
        ModuleRuntimeType module = (ModuleRuntimeType)this.modulesByNamespace.get((Object)templateName.module());
        return module == null ? Optional.empty() : Optional.ofNullable(module.yangDataChild(templateName));
    }

    public Set<CaseRuntimeType> allCaseChildren(ChoiceRuntimeType choiceType) {
        return this.choiceToCases.get((Object)choiceType.getIdentifier());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("modules", (Object)this.modulesByNamespace.keySet()).add("identities", this.identities.size()).add("types", this.types.size()).toString();
    }
}

