/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.codec.xml.NamespacePrefixes;
import org.opendaylight.yangtools.yang.data.codec.xml.PreferredPrefixes;
import org.opendaylight.yangtools.yang.data.codec.xml.XmlCodec;
import org.opendaylight.yangtools.yang.data.util.codec.IdentityCodecUtil;
import org.opendaylight.yangtools.yang.data.util.codec.QNameCodecUtil;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;

final class IdentityrefXmlCodec
implements XmlCodec<QName> {
    private final @NonNull EffectiveModelContext modelContext;
    private final @NonNull QNameModule parentModule;
    private final @Nullable PreferredPrefixes pref;

    IdentityrefXmlCodec(EffectiveModelContext modelContext, QNameModule parentModule, @Nullable PreferredPrefixes pref) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.parentModule = Objects.requireNonNull(parentModule);
        this.pref = pref;
    }

    public Class<QName> getDataType() {
        return QName.class;
    }

    public QName parseValue(NamespaceContext ctx, String str) {
        return IdentityCodecUtil.parseIdentity((String)str, (EffectiveModelContext)this.modelContext, prefix -> {
            if (prefix.isEmpty()) {
                return this.parentModule;
            }
            String prefixedNS = ctx.getNamespaceURI((String)prefix);
            Preconditions.checkArgument((prefixedNS != null ? 1 : 0) != 0, (String)"Failed to resolve prefix %s", (Object)prefix);
            Iterator modules = this.modelContext.findModuleStatements(XMLNamespace.of((String)prefixedNS)).iterator();
            Preconditions.checkArgument((boolean)modules.hasNext(), (String)"Could not find module for namespace %s", (Object)prefixedNS);
            return ((ModuleEffectiveStatement)modules.next()).localQNameModule();
        }).getQName();
    }

    @Override
    public void writeValue(XMLStreamWriter ctx, QName value) throws XMLStreamException {
        NamespacePrefixes prefixes = new NamespacePrefixes(ctx.getNamespaceContext(), this.pref);
        String str = QNameCodecUtil.encodeQName((QName)value, uri -> prefixes.encodePrefix(uri.namespace()));
        for (Map.Entry<XMLNamespace, String> entry : prefixes.emittedPrefixes()) {
            ctx.writeNamespace(entry.getValue(), entry.getKey().toString());
        }
        ctx.writeCharacters(str);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("module", (Object)this.parentModule).toString();
    }
}

