/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.impl.eff.AbstractChoiceEffectiveStatement;

public final class RegularChoiceEffectiveStatement
extends AbstractChoiceEffectiveStatement {
    private final CaseSchemaNode defaultCase;
    private final @NonNull QName argument;

    public RegularChoiceEffectiveStatement(ChoiceStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, QName argument, int flags, @Nullable CaseSchemaNode defaultCase) {
        super(declared, substatements, flags);
        this.argument = Objects.requireNonNull(argument);
        this.defaultCase = defaultCase;
    }

    public RegularChoiceEffectiveStatement(AbstractChoiceEffectiveStatement original, QName argument, int flags) {
        super(original, flags);
        this.argument = Objects.requireNonNull(argument);
        this.defaultCase = original.getDefaultCase().orElse(null);
    }

    public QName argument() {
        return this.argument;
    }

    public Optional<CaseSchemaNode> getDefaultCase() {
        return Optional.ofNullable(this.defaultCase);
    }
}

