/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DefaultEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DescriptionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UnitsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.ConcreteTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedBinaryType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedBitsType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedBooleanType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedDecimalType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedEmptyType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedEnumerationType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedIdentityrefType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInstanceIdentifierType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInt16Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInt32Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInt64Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedInt8Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedLeafrefType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedStringType;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUint16Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUint32Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUint64Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUint8Type;
import org.opendaylight.yangtools.yang.model.ri.type.DerivedUnionType;

@Beta
@NonNullByDefault
public final class ConcreteTypes {
    private ConcreteTypes() {
    }

    public static ConcreteTypeBuilder<?> concreteTypeBuilder(TypeDefinition<?> baseType, QName qname) {
        return ConcreteTypes.typeBuilderOf(baseType, qname);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="Ungrokked pattern match cast")
    private static ConcreteTypeBuilder<?> typeBuilderOf(TypeDefinition<?> baseType, QName qname) {
        TypeDefinition<?> typeDefinition = baseType;
        Objects.requireNonNull(typeDefinition);
        TypeDefinition<?> typeDefinition2 = typeDefinition;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BinaryTypeDefinition.class, BitsTypeDefinition.class, BooleanTypeDefinition.class, DecimalTypeDefinition.class, EmptyTypeDefinition.class, EnumTypeDefinition.class, IdentityrefTypeDefinition.class, InstanceIdentifierTypeDefinition.class, Int8TypeDefinition.class, Int16TypeDefinition.class, Int32TypeDefinition.class, Int64TypeDefinition.class, LeafrefTypeDefinition.class, StringTypeDefinition.class, UnionTypeDefinition.class, Uint8TypeDefinition.class, Uint16TypeDefinition.class, Uint32TypeDefinition.class, Uint64TypeDefinition.class}, typeDefinition2, n)) {
            case 0 -> {
                BinaryTypeDefinition binary = (BinaryTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteBinaryBuilder(binary, qname);
            }
            case 1 -> {
                BitsTypeDefinition bits = (BitsTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteBitsBuilder(bits, qname);
            }
            case 2 -> {
                BooleanTypeDefinition bool = (BooleanTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteBooleanBuilder(bool, qname);
            }
            case 3 -> {
                DecimalTypeDefinition decimal = (DecimalTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteDecimalBuilder(decimal, qname);
            }
            case 4 -> {
                EmptyTypeDefinition empty = (EmptyTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteEmptyBuilder(empty, qname);
            }
            case 5 -> {
                EnumTypeDefinition enumType = (EnumTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteEnumerationBuilder(enumType, qname);
            }
            case 6 -> {
                IdentityrefTypeDefinition identityRef = (IdentityrefTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteIdentityrefBuilder(identityRef, qname);
            }
            case 7 -> {
                InstanceIdentifierTypeDefinition iid = (InstanceIdentifierTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteInstanceIdentifierBuilder(iid, qname);
            }
            case 8 -> {
                Int8TypeDefinition int8 = (Int8TypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteInt8Builder(int8, qname);
            }
            case 9 -> {
                Int16TypeDefinition int16 = (Int16TypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteInt16Builder(int16, qname);
            }
            case 10 -> {
                Int32TypeDefinition int32 = (Int32TypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteInt32Builder(int32, qname);
            }
            case 11 -> {
                Int64TypeDefinition int64 = (Int64TypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteInt64Builder(int64, qname);
            }
            case 12 -> {
                LeafrefTypeDefinition leafRef = (LeafrefTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteLeafrefBuilder(leafRef, qname);
            }
            case 13 -> {
                StringTypeDefinition string = (StringTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteStringBuilder(string, qname);
            }
            case 14 -> {
                UnionTypeDefinition union = (UnionTypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteUnionBuilder(union, qname);
            }
            case 15 -> {
                Uint8TypeDefinition uint8 = (Uint8TypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteUint8Builder(uint8, qname);
            }
            case 16 -> {
                Uint16TypeDefinition uint16 = (Uint16TypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteUint16Builder(uint16, qname);
            }
            case 17 -> {
                Uint32TypeDefinition uint32 = (Uint32TypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteUint32Builder(uint32, qname);
            }
            case 18 -> {
                Uint64TypeDefinition uint64 = (Uint64TypeDefinition)typeDefinition2;
                yield ConcreteTypes.concreteUint64Builder(uint64, qname);
            }
            default -> throw new IllegalArgumentException("Unhandled type definition class " + String.valueOf(baseType.getClass()));
        };
    }

    public static TypeDefinition<?> typeOf(LeafEffectiveStatement leaf) {
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)leaf.findFirstEffectiveSubstatement(TypeEffectiveStatement.class).orElseThrow();
        ConcreteTypeBuilder<?> builder = ConcreteTypes.concreteTypeBuilder(typeStmt.getTypeDefinition(), (QName)leaf.argument());
        leaf.effectiveSubstatements().forEach(stmt -> {
            EffectiveStatement effectiveStatement = stmt;
            Objects.requireNonNull(effectiveStatement);
            EffectiveStatement selector0$temp = effectiveStatement;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DefaultEffectiveStatement.class, DescriptionEffectiveStatement.class, ReferenceEffectiveStatement.class, StatusEffectiveStatement.class, UnitsEffectiveStatement.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    DefaultEffectiveStatement dflt = (DefaultEffectiveStatement)selector0$temp;
                    builder.setDefaultValue(dflt.argument());
                    break;
                }
                case 1: {
                    DescriptionEffectiveStatement description = (DescriptionEffectiveStatement)selector0$temp;
                    builder.setDescription((String)description.argument());
                    break;
                }
                case 2: {
                    ReferenceEffectiveStatement reference = (ReferenceEffectiveStatement)selector0$temp;
                    builder.setReference((String)reference.argument());
                    break;
                }
                case 3: {
                    StatusEffectiveStatement status = (StatusEffectiveStatement)selector0$temp;
                    builder.setStatus((Status)status.argument());
                    break;
                }
                case 4: {
                    UnitsEffectiveStatement units = (UnitsEffectiveStatement)selector0$temp;
                    builder.setUnits((String)units.argument());
                    break;
                }
            }
        });
        return builder.build();
    }

    public static TypeDefinition<?> typeOf(LeafListEffectiveStatement leafList) {
        TypeEffectiveStatement typeStmt = (TypeEffectiveStatement)leafList.findFirstEffectiveSubstatement(TypeEffectiveStatement.class).orElseThrow();
        ConcreteTypeBuilder<?> builder = ConcreteTypes.concreteTypeBuilder(typeStmt.getTypeDefinition(), (QName)leafList.argument());
        leafList.effectiveSubstatements().forEach(stmt -> {
            EffectiveStatement effectiveStatement = stmt;
            Objects.requireNonNull(effectiveStatement);
            EffectiveStatement selector0$temp = effectiveStatement;
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DescriptionEffectiveStatement.class, ReferenceEffectiveStatement.class, StatusEffectiveStatement.class, UnitsEffectiveStatement.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    DescriptionEffectiveStatement description = (DescriptionEffectiveStatement)selector0$temp;
                    builder.setDescription((String)description.argument());
                    break;
                }
                case 1: {
                    ReferenceEffectiveStatement reference = (ReferenceEffectiveStatement)selector0$temp;
                    builder.setReference((String)reference.argument());
                    break;
                }
                case 2: {
                    StatusEffectiveStatement status = (StatusEffectiveStatement)selector0$temp;
                    builder.setStatus((Status)status.argument());
                    break;
                }
                case 3: {
                    UnitsEffectiveStatement units = (UnitsEffectiveStatement)selector0$temp;
                    builder.setUnits((String)units.argument());
                    break;
                }
            }
        });
        return builder.build();
    }

    private static ConcreteTypeBuilder<BinaryTypeDefinition> concreteBinaryBuilder(BinaryTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<BinaryTypeDefinition>(baseType, qname){

            @Override
            public BinaryTypeDefinition buildType() {
                return new DerivedBinaryType((BinaryTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<BitsTypeDefinition> concreteBitsBuilder(BitsTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<BitsTypeDefinition>(baseType, qname){

            @Override
            public BitsTypeDefinition buildType() {
                return new DerivedBitsType((BitsTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<BooleanTypeDefinition> concreteBooleanBuilder(BooleanTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<BooleanTypeDefinition>(baseType, qname){

            @Override
            public BooleanTypeDefinition buildType() {
                return new DerivedBooleanType((BooleanTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<DecimalTypeDefinition> concreteDecimalBuilder(DecimalTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<DecimalTypeDefinition>(baseType, qname){

            @Override
            public DecimalTypeDefinition buildType() {
                return new DerivedDecimalType((DecimalTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<EmptyTypeDefinition> concreteEmptyBuilder(EmptyTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<EmptyTypeDefinition>(baseType, qname){

            @Override
            public EmptyTypeDefinition buildType() {
                return new DerivedEmptyType((EmptyTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<EnumTypeDefinition> concreteEnumerationBuilder(EnumTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<EnumTypeDefinition>(baseType, qname){

            @Override
            public EnumTypeDefinition buildType() {
                return new DerivedEnumerationType((EnumTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<IdentityrefTypeDefinition> concreteIdentityrefBuilder(IdentityrefTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<IdentityrefTypeDefinition>(baseType, qname){

            @Override
            public IdentityrefTypeDefinition buildType() {
                return new DerivedIdentityrefType((IdentityrefTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<InstanceIdentifierTypeDefinition> concreteInstanceIdentifierBuilder(final InstanceIdentifierTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<InstanceIdentifierTypeDefinition>(baseType, qname){

            @Override
            public InstanceIdentifierTypeDefinition buildType() {
                return new DerivedInstanceIdentifierType((InstanceIdentifierTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes(), baseType.requireInstance());
            }
        };
    }

    private static ConcreteTypeBuilder<Int8TypeDefinition> concreteInt8Builder(Int8TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Int8TypeDefinition>(baseType, qname){

            @Override
            public Int8TypeDefinition buildType() {
                return new DerivedInt8Type((Int8TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Int16TypeDefinition> concreteInt16Builder(Int16TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Int16TypeDefinition>(baseType, qname){

            @Override
            public Int16TypeDefinition buildType() {
                return new DerivedInt16Type((Int16TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Int32TypeDefinition> concreteInt32Builder(Int32TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Int32TypeDefinition>(baseType, qname){

            @Override
            public Int32TypeDefinition buildType() {
                return new DerivedInt32Type((Int32TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Int64TypeDefinition> concreteInt64Builder(Int64TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Int64TypeDefinition>(baseType, qname){

            @Override
            public Int64TypeDefinition buildType() {
                return new DerivedInt64Type((Int64TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<LeafrefTypeDefinition> concreteLeafrefBuilder(LeafrefTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<LeafrefTypeDefinition>(baseType, qname){

            @Override
            public LeafrefTypeDefinition buildType() {
                return new DerivedLeafrefType((LeafrefTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<StringTypeDefinition> concreteStringBuilder(StringTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<StringTypeDefinition>(baseType, qname){

            @Override
            public StringTypeDefinition buildType() {
                return new DerivedStringType((StringTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<UnionTypeDefinition> concreteUnionBuilder(UnionTypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<UnionTypeDefinition>(baseType, qname){

            @Override
            public DerivedUnionType buildType() {
                return new DerivedUnionType((UnionTypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint8TypeDefinition> concreteUint8Builder(Uint8TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Uint8TypeDefinition>(baseType, qname){

            @Override
            public Uint8TypeDefinition buildType() {
                return new DerivedUint8Type((Uint8TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint16TypeDefinition> concreteUint16Builder(Uint16TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Uint16TypeDefinition>(baseType, qname){

            @Override
            public Uint16TypeDefinition buildType() {
                return new DerivedUint16Type((Uint16TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint32TypeDefinition> concreteUint32Builder(Uint32TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Uint32TypeDefinition>(baseType, qname){

            @Override
            public Uint32TypeDefinition buildType() {
                return new DerivedUint32Type((Uint32TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }

    private static ConcreteTypeBuilder<Uint64TypeDefinition> concreteUint64Builder(Uint64TypeDefinition baseType, QName qname) {
        return new ConcreteTypeBuilder<Uint64TypeDefinition>(baseType, qname){

            @Override
            public Uint64TypeDefinition buildType() {
                return new DerivedUint64Type((Uint64TypeDefinition)this.getBaseType(), this.getQName(), this.getDefaultValue(), this.getDescription(), this.getReference(), this.getStatus(), this.getUnits(), this.getUnknownSchemaNodes());
            }
        };
    }
}

