/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.ri.type;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.ri.type.AbstractRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.ri.type.BaseEnumerationType;
import org.opendaylight.yangtools.yang.model.ri.type.InvalidEnumDefinitionException;
import org.opendaylight.yangtools.yang.model.ri.type.RestrictedEnumerationType;

public final class EnumerationTypeBuilder
extends AbstractRestrictedTypeBuilder<EnumTypeDefinition> {
    private final ImmutableMap.Builder<String, EnumTypeDefinition.EnumPair> builder = ImmutableMap.builder();

    EnumerationTypeBuilder(QName qname) {
        super(null, qname);
    }

    EnumerationTypeBuilder(EnumTypeDefinition baseType, QName qname) {
        super(baseType, qname);
    }

    public EnumerationTypeBuilder addEnum(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EnumTypeDefinition.EnumPair item) {
        EnumTypeDefinition base = (EnumTypeDefinition)this.getBaseType();
        if (base != null) {
            EnumerationTypeBuilder.validateRestrictedEnum(item, base);
        }
        this.builder.put((Object)item.getName(), (Object)item);
        this.touch();
        return this;
    }

    private static void validateRestrictedEnum(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull EnumTypeDefinition.EnumPair item, @NonNull EnumTypeDefinition base) {
        boolean isASubsetOfBaseEnums = false;
        for (EnumTypeDefinition.EnumPair baseTypeEnumPair : base.getValues()) {
            if (!item.getName().equals(baseTypeEnumPair.getName())) continue;
            if (item.getValue() != baseTypeEnumPair.getValue()) {
                throw new InvalidEnumDefinitionException(item, "Value of enum '%s' must be the same as the value of corresponding enum in the base enumeration type %s.", item.getName(), base.getQName());
            }
            isASubsetOfBaseEnums = true;
            break;
        }
        if (!isASubsetOfBaseEnums) {
            throw new InvalidEnumDefinitionException(item, "Enum '%s' is not a subset of its base enumeration type %s.", item.getName(), base.getQName());
        }
    }

    @Override
    public EnumTypeDefinition buildType() {
        ImmutableMap byName = this.builder.build();
        HashMap<Integer, EnumTypeDefinition.EnumPair> byValue = new HashMap<Integer, EnumTypeDefinition.EnumPair>();
        for (EnumTypeDefinition.EnumPair pair : byName.values()) {
            int value = pair.getValue();
            EnumTypeDefinition.EnumPair conflict = byValue.put(value, pair);
            if (conflict == null) continue;
            throw new InvalidEnumDefinitionException(pair, "Enum '%s' conflicts on value %s with enum '%s'", pair.getName(), value, conflict.getName());
        }
        return this.getBaseType() == null ? new BaseEnumerationType(this.getQName(), this.getUnknownSchemaNodes(), (Collection<EnumTypeDefinition.EnumPair>)byName.values()) : new RestrictedEnumerationType((EnumTypeDefinition)this.getBaseType(), this.getQName(), this.getUnknownSchemaNodes(), (Collection<EnumTypeDefinition.EnumPair>)byName.values());
    }
}

