/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sample.kitchen.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.controller.md.sal.common.util.jmx.AbstractMXBean;
import org.opendaylight.controller.sample.kitchen.api.EggsType;
import org.opendaylight.controller.sample.kitchen.api.KitchenService;
import org.opendaylight.controller.sample.kitchen.api.KitchenServiceRuntimeMXBean;
import org.opendaylight.mdsal.binding.api.NotificationService;
import org.opendaylight.mdsal.binding.api.RpcService;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToast;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastInputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastOutput;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.MakeToastOutputBuilder;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToastType;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterOutOfBread;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterRestocked;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.WheatBread;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={KitchenService.class}, immediate=true)
public final class KitchenServiceImpl
extends AbstractMXBean
implements KitchenService,
KitchenServiceRuntimeMXBean {
    private static final Logger LOG = LoggerFactory.getLogger(KitchenServiceImpl.class);
    private static final MakeToastOutput EMPTY_MAKE_OUTPUT = new MakeToastOutputBuilder().build();
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final MakeToast makeToast;
    private final Registration reg;
    private volatile boolean toasterOutOfBread;

    @Inject
    @Activate
    public KitchenServiceImpl(@Reference RpcService rpcService, @Reference NotificationService notifService) {
        super("KitchenService", "toaster-consumer", null);
        this.makeToast = (MakeToast)rpcService.getRpc(MakeToast.class);
        this.reg = notifService.registerCompositeListener(new NotificationService.CompositeListener(Set.of(new NotificationService.CompositeListener.Component(ToasterOutOfBread.class, notification -> {
            LOG.info("ToasterOutOfBread notification");
            this.toasterOutOfBread = true;
        }), new NotificationService.CompositeListener.Component(ToasterRestocked.class, notification -> {
            LOG.info("ToasterRestocked notification - amountOfBread: {}", (Object)notification.getAmountOfBread());
            this.toasterOutOfBread = false;
        }))));
        this.register();
    }

    @PreDestroy
    @Deactivate
    public void close() {
        this.unregister();
        this.reg.close();
    }

    @Override
    public ListenableFuture<RpcResult<Void>> makeBreakfast(EggsType eggsType, ToastType toastType, int toastDoneness) {
        ListenableFuture<RpcResult<MakeToastOutput>> makeToastFuture = this.makeToast(toastType, toastDoneness);
        ListenableFuture<RpcResult<Void>> makeEggsFuture = this.makeEggs(eggsType);
        ListenableFuture combinedFutures = Futures.allAsList((Iterable)ImmutableList.of(makeToastFuture, makeEggsFuture));
        return Futures.transformAsync((ListenableFuture)combinedFutures, results -> {
            boolean atLeastOneSucceeded = false;
            ImmutableList.Builder errorList = ImmutableList.builder();
            for (RpcResult result : results) {
                if (result.isSuccessful()) {
                    atLeastOneSucceeded = true;
                }
                if (result.getErrors() == null) continue;
                errorList.addAll((Iterable)result.getErrors());
            }
            return RpcResultBuilder.status((boolean)atLeastOneSucceeded).withRpcErrors((Collection)errorList.build()).buildFuture();
        }, (Executor)MoreExecutors.directExecutor());
    }

    private ListenableFuture<RpcResult<Void>> makeEggs(EggsType eggsType) {
        return Futures.submit(() -> RpcResultBuilder.success().build(), (Executor)this.executor);
    }

    private ListenableFuture<RpcResult<MakeToastOutput>> makeToast(ToastType toastType, int toastDoneness) {
        if (this.toasterOutOfBread) {
            LOG.info("We're out of toast but we can make eggs");
            return RpcResultBuilder.success((Object)EMPTY_MAKE_OUTPUT).withWarning(ErrorType.APPLICATION, ErrorTag.PARTIAL_OPERATION, "Toaster is out of bread but we can make you eggs").buildFuture();
        }
        return this.makeToast.invoke(new MakeToastInputBuilder().setToasterDoneness(Uint32.valueOf((int)toastDoneness)).setToasterToastType(toastType).build());
    }

    @Override
    public Boolean makeScrambledWithWheat() {
        try {
            RpcResult result = (RpcResult)this.makeBreakfast(EggsType.SCRAMBLED, (ToastType)WheatBread.VALUE, 2).get();
            if (result.isSuccessful()) {
                LOG.info("makeBreakfast succeeded");
            } else {
                LOG.warn("makeBreakfast failed: {}", (Object)result.getErrors());
            }
            return result.isSuccessful();
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("An error occurred while maing breakfast", (Throwable)e);
            return Boolean.FALSE;
        }
    }
}

