/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.akka.segjournal;

import akka.actor.ActorSystem;
import akka.actor.ExtendedActorSystem;
import akka.persistence.PersistentRepr;
import akka.serialization.JavaSerializer;
import com.google.common.base.VerifyException;
import io.atomix.storage.journal.JournalSerdes;
import java.io.IOException;
import java.util.Objects;
import org.opendaylight.controller.akka.segjournal.DataJournalEntry;

final class DataJournalEntrySerdes
implements JournalSerdes.EntrySerdes<DataJournalEntry> {
    private final ExtendedActorSystem actorSystem;

    DataJournalEntrySerdes(ActorSystem actorSystem) {
        this.actorSystem = Objects.requireNonNull((ExtendedActorSystem)actorSystem);
    }

    public void write(JournalSerdes.EntryOutput output, DataJournalEntry entry) throws IOException {
        if (!(entry instanceof DataJournalEntry.ToPersistence)) {
            throw new VerifyException("Unexpected entry " + String.valueOf(entry));
        }
        DataJournalEntry.ToPersistence toPersistence = (DataJournalEntry.ToPersistence)entry;
        PersistentRepr repr = toPersistence.repr();
        output.writeString(repr.manifest());
        output.writeString(repr.writerUuid());
        output.writeObject(repr.payload());
    }

    public DataJournalEntry read(JournalSerdes.EntryInput input) throws IOException {
        return new DataJournalEntry.FromPersistence(input.readString(), input.readString(), JavaSerializer.currentSystem().withValue(this.actorSystem, () -> ((JournalSerdes.EntryInput)input).readObject()));
    }
}

