/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.akka.segjournal;

import akka.actor.ActorRef;
import akka.dispatch.Futures;
import akka.persistence.AtomicWrite;
import akka.persistence.PersistentRepr;
import akka.persistence.journal.japi.AsyncWriteJournal;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import io.atomix.storage.journal.StorageLevel;
import java.io.File;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.opendaylight.controller.akka.segjournal.SegmentedJournalActor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

public class SegmentedFileJournal
extends AsyncWriteJournal {
    public static final String STORAGE_ROOT_DIRECTORY = "root-directory";
    public static final String STORAGE_MAX_ENTRY_SIZE = "max-entry-size";
    public static final int STORAGE_MAX_ENTRY_SIZE_DEFAULT = 0x1000000;
    public static final String STORAGE_MAX_SEGMENT_SIZE = "max-segment-size";
    public static final int STORAGE_MAX_SEGMENT_SIZE_DEFAULT = 0x8000000;
    public static final String STORAGE_MAX_UNFLUSHED_BYTES = "max-unflushed-bytes";
    public static final String STORAGE_MEMORY_MAPPED = "memory-mapped";
    private static final Logger LOG = LoggerFactory.getLogger(SegmentedFileJournal.class);
    private final Map<String, ActorRef> handlers = new HashMap<String, ActorRef>();
    private final File rootDir;
    private final StorageLevel storage;
    private final int maxEntrySize;
    private final int maxSegmentSize;
    private final int maxUnflushedBytes;

    public SegmentedFileJournal(Config config) {
        this.rootDir = new File(config.getString(STORAGE_ROOT_DIRECTORY));
        if (!this.rootDir.exists()) {
            LOG.debug("Creating directory {}", (Object)this.rootDir);
            Preconditions.checkState((boolean)this.rootDir.mkdirs(), (String)"Failed to create root directory %s", (Object)this.rootDir);
        }
        Preconditions.checkArgument((boolean)this.rootDir.isDirectory(), (String)"%s is not a directory", (Object)this.rootDir);
        this.maxEntrySize = SegmentedFileJournal.getBytes(config, STORAGE_MAX_ENTRY_SIZE, 0x1000000);
        this.maxSegmentSize = SegmentedFileJournal.getBytes(config, STORAGE_MAX_SEGMENT_SIZE, 0x8000000);
        this.maxUnflushedBytes = SegmentedFileJournal.getBytes(config, STORAGE_MAX_UNFLUSHED_BYTES, this.maxEntrySize);
        this.storage = config.hasPath(STORAGE_MEMORY_MAPPED) ? (config.getBoolean(STORAGE_MEMORY_MAPPED) ? StorageLevel.MAPPED : StorageLevel.DISK) : StorageLevel.DISK;
        LOG.info("Initialized with root directory {} with storage {}", (Object)this.rootDir, (Object)this.storage);
    }

    public Future<Iterable<Optional<Exception>>> doAsyncWriteMessages(Iterable<AtomicWrite> messages) {
        HashMap<ActorRef, SegmentedJournalActor.WriteMessages> map = new HashMap<ActorRef, SegmentedJournalActor.WriteMessages>();
        ArrayList<Future<Optional<Exception>>> result = new ArrayList<Future<Optional<Exception>>>();
        for (AtomicWrite message2 : messages) {
            String persistenceId = message2.persistenceId();
            ActorRef handler2 = this.handlers.computeIfAbsent(persistenceId, this::createHandler);
            result.add(map.computeIfAbsent(handler2, key -> new SegmentedJournalActor.WriteMessages()).add(message2));
        }
        map.forEach((handler, message) -> {
            LOG.trace("Sending {} to {}", message, handler);
            handler.tell(message, ActorRef.noSender());
        });
        return Futures.sequence(result, (ExecutionContext)this.context().dispatcher());
    }

    public Future<Void> doAsyncDeleteMessagesTo(String persistenceId, long toSequenceNr) {
        return this.delegateMessage(persistenceId, SegmentedJournalActor.deleteMessagesTo(toSequenceNr));
    }

    public Future<Void> doAsyncReplayMessages(String persistenceId, long fromSequenceNr, long toSequenceNr, long max, Consumer<PersistentRepr> replayCallback) {
        return this.delegateMessage(persistenceId, SegmentedJournalActor.replayMessages(fromSequenceNr, toSequenceNr, max, replayCallback));
    }

    public Future<Long> doAsyncReadHighestSequenceNr(String persistenceId, long fromSequenceNr) {
        return SegmentedFileJournal.delegateMessage(this.handlers.computeIfAbsent(persistenceId, this::createHandler), SegmentedJournalActor.readHighestSequenceNr(fromSequenceNr));
    }

    private ActorRef createHandler(String persistenceId) {
        String directoryName = URLEncoder.encode(persistenceId, StandardCharsets.UTF_8);
        File directory = new File(this.rootDir, directoryName);
        LOG.debug("Creating handler for {} in directory {}", (Object)persistenceId, (Object)directory);
        ActorRef handler = this.context().actorOf(SegmentedJournalActor.props(persistenceId, directory, this.storage, this.maxEntrySize, this.maxSegmentSize, this.maxUnflushedBytes));
        LOG.debug("Directory {} handled by {}", (Object)directory, (Object)handler);
        return handler;
    }

    private <T> Future<T> delegateMessage(String persistenceId, SegmentedJournalActor.AsyncMessage<T> message) {
        ActorRef handler = this.handlers.get(persistenceId);
        if (handler == null) {
            return Futures.failed((Throwable)new IllegalStateException("Cannot find handler for " + persistenceId));
        }
        return SegmentedFileJournal.delegateMessage(handler, message);
    }

    private static <T> Future<T> delegateMessage(ActorRef handler, SegmentedJournalActor.AsyncMessage<T> message) {
        LOG.trace("Delegating {} to {}", message, (Object)handler);
        handler.tell(message, ActorRef.noSender());
        return message.promise.future();
    }

    private static int getBytes(Config config, String path, int defaultValue) {
        if (!config.hasPath(path)) {
            return defaultValue;
        }
        long value = config.getBytes(path);
        Preconditions.checkArgument((value <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Size %s exceeds maximum allowed %s", (int)Integer.MAX_VALUE);
        return (int)value;
    }
}

