/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.akka.segjournal;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import akka.actor.Props;
import akka.japi.pf.ReceiveBuilder;
import akka.persistence.AtomicWrite;
import akka.persistence.PersistentRepr;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import io.atomix.storage.journal.Indexed;
import io.atomix.storage.journal.JournalSerdes;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.SegmentedByteBufJournal;
import io.atomix.storage.journal.SegmentedJournal;
import io.atomix.storage.journal.StorageLevel;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.opendaylight.controller.akka.segjournal.DataJournal;
import org.opendaylight.controller.akka.segjournal.DataJournalV0;
import org.opendaylight.controller.akka.segjournal.LongEntrySerdes;
import org.opendaylight.controller.cluster.reporting.MetricsReporter;
import org.opendaylight.controller.raft.journal.FromByteBufMapper;
import org.opendaylight.controller.raft.journal.RaftJournal;
import org.opendaylight.controller.raft.journal.ToByteBufMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;
import scala.concurrent.Promise;

abstract sealed class SegmentedJournalActor
extends AbstractActor {
    private static final Logger LOG = LoggerFactory.getLogger(SegmentedJournalActor.class);
    private static final int DELETE_SEGMENT_SIZE = 65536;
    private static final FromByteBufMapper<Long> READ_MAPPER;
    private static final ToByteBufMapper<Long> WRITE_MAPPER;
    private final String persistenceId;
    private final StorageLevel storage;
    private final int maxSegmentSize;
    private final int maxEntrySize;
    private final File directory;
    private Timer batchWriteTime;
    private Meter messageWriteCount;
    private Histogram messageSize;
    private Histogram flushMessages;
    private Histogram flushBytes;
    private Timer flushTime;
    private DataJournal dataJournal;
    private SegmentedJournal<Long> deleteJournal;
    private long lastDelete;

    private SegmentedJournalActor(String persistenceId, File directory, StorageLevel storage, int maxEntrySize, int maxSegmentSize) {
        this.persistenceId = Objects.requireNonNull(persistenceId);
        this.directory = Objects.requireNonNull(directory);
        this.storage = Objects.requireNonNull(storage);
        this.maxEntrySize = maxEntrySize;
        this.maxSegmentSize = maxSegmentSize;
    }

    static Props props(String persistenceId, File directory, StorageLevel storage, int maxEntrySize, int maxSegmentSize, int maxUnflushedBytes) {
        String pid = Objects.requireNonNull(persistenceId);
        return maxUnflushedBytes > 0 ? Props.create(Delayed.class, (Object[])new Object[]{pid, directory, storage, maxEntrySize, maxSegmentSize, maxUnflushedBytes}) : Props.create(Immediate.class, (Object[])new Object[]{pid, directory, storage, maxEntrySize, maxSegmentSize});
    }

    final String persistenceId() {
        return this.persistenceId;
    }

    final void flushJournal(long bytes, int messages) {
        Stopwatch sw = Stopwatch.createStarted();
        this.dataJournal.flush();
        LOG.debug("{}: journal flush completed in {}", (Object)this.persistenceId, (Object)sw.stop());
        this.flushBytes.update(bytes);
        this.flushMessages.update(messages);
        this.flushTime.update(sw.elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
    }

    public AbstractActor.Receive createReceive() {
        return this.addMessages(this.receiveBuilder()).matchAny(this::handleUnknown).build();
    }

    ReceiveBuilder addMessages(ReceiveBuilder builder) {
        return builder.match(DeleteMessagesTo.class, this::handleDeleteMessagesTo).match(ReadHighestSequenceNr.class, this::handleReadHighestSequenceNr).match(ReplayMessages.class, this::handleReplayMessages).match(WriteMessages.class, this::handleWriteMessages);
    }

    public void preStart() throws Exception {
        LOG.debug("{}: actor starting", (Object)this.persistenceId);
        super.preStart();
        MetricRegistry registry = MetricsReporter.getInstance((String)"org.opendaylight.controller.actor.metric").getMetricsRegistry();
        String actorName = this.self().path().parent().toStringWithoutAddress() + "/" + this.directory.getName();
        this.batchWriteTime = registry.timer(MetricRegistry.name((String)actorName, (String[])new String[]{"batchWriteTime"}));
        this.messageWriteCount = registry.meter(MetricRegistry.name((String)actorName, (String[])new String[]{"messageWriteCount"}));
        this.messageSize = registry.histogram(MetricRegistry.name((String)actorName, (String[])new String[]{"messageSize"}));
        this.flushBytes = registry.histogram(MetricRegistry.name((String)actorName, (String[])new String[]{"flushBytes"}));
        this.flushMessages = registry.histogram(MetricRegistry.name((String)actorName, (String[])new String[]{"flushMessages"}));
        this.flushTime = registry.timer(MetricRegistry.name((String)actorName, (String[])new String[]{"flushTime"}));
    }

    public void postStop() throws Exception {
        LOG.debug("{}: actor stopping", (Object)this.persistenceId);
        if (this.dataJournal != null) {
            this.dataJournal.close();
            LOG.debug("{}: data journal closed", (Object)this.persistenceId);
            this.dataJournal = null;
        }
        if (this.deleteJournal != null) {
            this.deleteJournal.close();
            LOG.debug("{}: delete journal closed", (Object)this.persistenceId);
            this.deleteJournal = null;
        }
        LOG.debug("{}: actor stopped", (Object)this.persistenceId);
        super.postStop();
    }

    static AsyncMessage<Void> deleteMessagesTo(long toSequenceNr) {
        return new DeleteMessagesTo(toSequenceNr);
    }

    static AsyncMessage<Long> readHighestSequenceNr(long fromSequenceNr) {
        return new ReadHighestSequenceNr(fromSequenceNr);
    }

    static AsyncMessage<Void> replayMessages(long fromSequenceNr, long toSequenceNr, long max, Consumer<PersistentRepr> replayCallback) {
        return new ReplayMessages(fromSequenceNr, toSequenceNr, max, replayCallback);
    }

    private void handleDeleteMessagesTo(DeleteMessagesTo message) {
        this.ensureOpen();
        LOG.debug("{}: delete messages {}", (Object)this.persistenceId, (Object)message);
        this.flushWrites();
        long to = Long.min(this.dataJournal.lastWrittenSequenceNr(), message.toSequenceNr);
        LOG.debug("{}: adjusted delete to {}", (Object)this.persistenceId, (Object)to);
        if (this.lastDelete < to) {
            LOG.debug("{}: deleting entries up to {}", (Object)this.persistenceId, (Object)to);
            this.lastDelete = to;
            JournalWriter deleteWriter = this.deleteJournal.writer();
            Indexed entry = deleteWriter.append((Object)this.lastDelete);
            deleteWriter.commit(entry.index());
            this.dataJournal.deleteTo(this.lastDelete);
            LOG.debug("{}: compaction started", (Object)this.persistenceId);
            this.dataJournal.compactTo(this.lastDelete);
            this.deleteJournal.compact(entry.index());
            LOG.debug("{}: compaction finished", (Object)this.persistenceId);
        } else {
            LOG.debug("{}: entries up to {} already deleted", (Object)this.persistenceId, (Object)this.lastDelete);
        }
        message.promise.success(null);
    }

    private void handleReadHighestSequenceNr(ReadHighestSequenceNr message) {
        Long sequence;
        LOG.debug("{}: looking for highest sequence on {}", (Object)this.persistenceId, (Object)message);
        if (this.directory.isDirectory()) {
            this.ensureOpen();
            this.flushWrites();
            sequence = this.dataJournal.lastWrittenSequenceNr();
        } else {
            sequence = 0L;
        }
        LOG.debug("{}: highest sequence is {}", (Object)message, (Object)sequence);
        message.promise.success((Object)sequence);
    }

    private void handleReplayMessages(ReplayMessages message) {
        LOG.debug("{}: replaying messages {}", (Object)this.persistenceId, (Object)message);
        this.ensureOpen();
        this.flushWrites();
        long from = Long.max(this.lastDelete + 1L, message.fromSequenceNr);
        LOG.debug("{}: adjusted fromSequenceNr to {}", (Object)this.persistenceId, (Object)from);
        this.dataJournal.handleReplayMessages(message, from);
    }

    private void handleWriteMessages(WriteMessages message) {
        this.ensureOpen();
        Stopwatch started = Stopwatch.createStarted();
        long start = this.dataJournal.lastWrittenSequenceNr();
        WrittenMessages writtenMessages = this.dataJournal.handleWriteMessages(message);
        this.onWrittenMessages(writtenMessages, started, this.dataJournal.lastWrittenSequenceNr() - start);
    }

    final void completeWriteMessages(WrittenMessages message, Stopwatch started, long count) {
        this.batchWriteTime.update(started.stop().elapsed(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        this.messageWriteCount.mark(count);
        LOG.debug("{}: write of {} bytes completed in {}", new Object[]{this.persistenceId, message.writtenBytes, started});
        message.complete();
    }

    abstract void onWrittenMessages(WrittenMessages var1, Stopwatch var2, long var3);

    private void handleUnknown(Object message) {
        LOG.error("{}: Received unknown message {}", (Object)this.persistenceId, message);
    }

    private void ensureOpen() {
        if (this.dataJournal != null) {
            Verify.verifyNotNull(this.deleteJournal);
            return;
        }
        Stopwatch sw = Stopwatch.createStarted();
        this.deleteJournal = new SegmentedJournal((RaftJournal)SegmentedByteBufJournal.builder().withDirectory(this.directory).withName("delete").withMaxSegmentSize(65536).build(), READ_MAPPER, WRITE_MAPPER);
        Long lastDeleteRecovered = (Long)this.deleteJournal.openReader(this.deleteJournal.lastIndex()).tryNext((index, value, length) -> value);
        this.lastDelete = lastDeleteRecovered == null ? 0L : lastDeleteRecovered;
        this.dataJournal = new DataJournalV0(this.persistenceId, this.messageSize, this.context().system(), this.storage, this.directory, this.maxEntrySize, this.maxSegmentSize);
        this.dataJournal.deleteTo(this.lastDelete);
        LOG.debug("{}: journal open in {} with last index {}, deleted to {}", new Object[]{this.persistenceId, sw, this.dataJournal.lastWrittenSequenceNr(), this.lastDelete});
    }

    abstract void flushWrites();

    static {
        JournalSerdes namespace = JournalSerdes.builder().register((JournalSerdes.EntrySerdes)LongEntrySerdes.LONG_ENTRY_SERDES, new Class[]{Long.class}).build();
        READ_MAPPER = namespace.toReadMapper();
        WRITE_MAPPER = namespace.toWriteMapper();
    }

    private static final class Delayed
    extends SegmentedJournalActor {
        private final ArrayDeque<UnflushedWrite> unflushedWrites = new ArrayDeque();
        private final Stopwatch unflushedDuration = Stopwatch.createUnstarted();
        private final long maxUnflushedBytes;
        private long batch = 0L;
        private long unflushedBytes = 0L;

        Delayed(String persistenceId, File directory, StorageLevel storage, int maxEntrySize, int maxSegmentSize, int maxUnflushedBytes) {
            super(persistenceId, directory, storage, maxEntrySize, maxSegmentSize);
            this.maxUnflushedBytes = maxUnflushedBytes;
        }

        @Override
        ReceiveBuilder addMessages(ReceiveBuilder builder) {
            return super.addMessages(builder).match(Flush.class, this::handleFlush);
        }

        private void handleFlush(Flush message) {
            if (message.batch == this.batch) {
                this.flushWrites();
            } else {
                LOG.debug("{}: batch {} not flushed by {}", new Object[]{this.persistenceId(), this.batch, message.batch});
            }
        }

        @Override
        void onWrittenMessages(WrittenMessages message, Stopwatch started, long count) {
            boolean first = this.unflushedWrites.isEmpty();
            if (first) {
                this.unflushedDuration.start();
            }
            this.unflushedWrites.addLast(new UnflushedWrite(message, started, count));
            this.unflushedBytes += message.writtenBytes;
            if (this.unflushedBytes >= this.maxUnflushedBytes) {
                LOG.debug("{}: reached {} unflushed journal bytes", (Object)this.persistenceId(), (Object)this.unflushedBytes);
                this.flushWrites();
            } else if (first) {
                LOG.debug("{}: deferring journal flush", (Object)this.persistenceId());
                this.self().tell((Object)new Flush(++this.batch), ActorRef.noSender());
            }
        }

        @Override
        void flushWrites() {
            int unsyncedSize = this.unflushedWrites.size();
            if (unsyncedSize == 0) {
                return;
            }
            LOG.debug("{}: flushing {} journal writes after {}", new Object[]{this.persistenceId(), unsyncedSize, this.unflushedDuration.stop()});
            this.flushJournal(this.unflushedBytes, unsyncedSize);
            Stopwatch sw = Stopwatch.createStarted();
            this.unflushedWrites.forEach(write -> this.completeWriteMessages(write.message, write.start, write.count));
            this.unflushedWrites.clear();
            this.unflushedBytes = 0L;
            this.unflushedDuration.reset();
            LOG.debug("{}: completed {} flushed journal writes in {}", new Object[]{this.persistenceId(), unsyncedSize, sw});
        }

        private static final class Flush
        extends AsyncMessage<Void> {
            final long batch;

            Flush(long batch) {
                this.batch = batch;
            }
        }

        private record UnflushedWrite(WrittenMessages message, Stopwatch start, long count) {
            UnflushedWrite {
                Objects.requireNonNull(message);
                Objects.requireNonNull(start);
            }
        }
    }

    private static final class Immediate
    extends SegmentedJournalActor {
        Immediate(String persistenceId, File directory, StorageLevel storage, int maxEntrySize, int maxSegmentSize) {
            super(persistenceId, directory, storage, maxEntrySize, maxSegmentSize);
        }

        @Override
        void onWrittenMessages(WrittenMessages message, Stopwatch started, long count) {
            this.flushJournal(message.writtenBytes, 1);
            this.completeWriteMessages(message, started, count);
        }

        @Override
        void flushWrites() {
        }
    }

    private static final class DeleteMessagesTo
    extends AsyncMessage<Void> {
        final long toSequenceNr;

        DeleteMessagesTo(long toSequenceNr) {
            this.toSequenceNr = toSequenceNr;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("toSequenceNr", this.toSequenceNr).toString();
        }
    }

    private static final class ReadHighestSequenceNr
    extends AsyncMessage<Long> {
        private final long fromSequenceNr;

        ReadHighestSequenceNr(long fromSequenceNr) {
            this.fromSequenceNr = fromSequenceNr;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fromSequenceNr", this.fromSequenceNr).toString();
        }
    }

    static final class ReplayMessages
    extends AsyncMessage<Void> {
        private final long fromSequenceNr;
        final long toSequenceNr;
        final long max;
        final Consumer<PersistentRepr> replayCallback;

        ReplayMessages(long fromSequenceNr, long toSequenceNr, long max, Consumer<PersistentRepr> replayCallback) {
            this.fromSequenceNr = fromSequenceNr;
            this.toSequenceNr = toSequenceNr;
            this.max = max;
            this.replayCallback = Objects.requireNonNull(replayCallback);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("fromSequenceNr", this.fromSequenceNr).add("toSequenceNr", this.toSequenceNr).add("max", this.max).toString();
        }
    }

    static final class WriteMessages {
        private final List<AtomicWrite> requests = new ArrayList<AtomicWrite>();
        private final List<Promise<Optional<Exception>>> results = new ArrayList<Promise<Optional<Exception>>>();

        WriteMessages() {
        }

        Future<Optional<Exception>> add(AtomicWrite write) {
            Promise promise = Promise.apply();
            this.requests.add(write);
            this.results.add((Promise<Optional<Exception>>)promise);
            return promise.future();
        }

        int size() {
            return this.requests.size();
        }

        AtomicWrite getRequest(int index) {
            return this.requests.get(index);
        }

        void setFailure(int index, Exception cause) {
            this.results.get(index).success(Optional.of(cause));
        }

        void setSuccess(int index) {
            this.results.get(index).success(Optional.empty());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("requests", this.requests).toString();
        }
    }

    record WrittenMessages(WriteMessages message, List<Object> responses, long writtenBytes) {
        WrittenMessages {
            Verify.verify((responses.size() == message.size() ? 1 : 0) != 0, (String)"Mismatched %s and %s", (Object)message, responses);
            Verify.verify((writtenBytes >= 0L ? 1 : 0) != 0, (String)"Unexpected length %s", (long)writtenBytes);
        }

        private void complete() {
            int size = this.responses.size();
            for (int i = 0; i < size; ++i) {
                Object object = this.responses.get(i);
                if (object instanceof Exception) {
                    Exception ex = (Exception)object;
                    this.message.setFailure(i, ex);
                    continue;
                }
                this.message.setSuccess(i);
            }
        }
    }

    static abstract sealed class AsyncMessage<T>
    permits ReadHighestSequenceNr, ReplayMessages, DeleteMessagesTo, Delayed.Flush {
        final Promise<T> promise = Promise.apply();

        AsyncMessage() {
        }
    }
}

