/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureSet;

public abstract sealed class IfFeatureExpr
implements Immutable,
Predicate<FeatureSet> {
    public static final @NonNull IfFeatureExpr isPresent(QName qname) {
        return new Present(qname);
    }

    public static final @NonNull IfFeatureExpr and(Set<IfFeatureExpr> exprs) {
        return IfFeatureExpr.compose(exprs, All::new, NotAny::new, AllExprs::new);
    }

    public static final @NonNull IfFeatureExpr or(Set<IfFeatureExpr> exprs) {
        return IfFeatureExpr.compose(exprs, Any::new, NotAll::new, AnyExpr::new);
    }

    public abstract @NonNull Set<QName> getReferencedFeatures();

    public abstract @NonNull IfFeatureExpr negate();

    @Override
    public abstract boolean test(FeatureSet var1);

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    abstract void addQNames(@NonNull Set<QName> var1);

    private static @NonNull IfFeatureExpr compose(Set<IfFeatureExpr> exprs, Function<QName[], @NonNull Compound> allPresent, Function<QName[], @NonNull Compound> allAbsent, Function<IfFeatureExpr[], @NonNull Complex> mixed) {
        return switch (exprs.size()) {
            case 0 -> throw new IllegalArgumentException("Expressions may not be empty");
            case 1 -> Objects.requireNonNull(exprs.iterator().next());
            default -> {
                boolean negative = false;
                boolean positive = false;
                block9: for (IfFeatureExpr expr : exprs) {
                    IfFeatureExpr var8_8;
                    Objects.requireNonNull(expr);
                    int var9_9 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Present.class, Absent.class, AbstractArray.class}, (Object)var8_8, var9_9)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            Present present = (Present)var8_8;
                            positive = true;
                            continue block9;
                        }
                        case 1: {
                            Absent absent = (Absent)var8_8;
                            negative = true;
                            continue block9;
                        }
                        case 2: 
                    }
                    AbstractArray array = (AbstractArray)var8_8;
                    positive = true;
                    negative = true;
                }
                Verify.verify((negative || positive ? 1 : 0) != 0, (String)"Unresolved expressions %s", exprs);
                if (positive == negative) {
                    yield mixed.apply(exprs.toArray(new IfFeatureExpr[0]));
                }
                QName[] qnames = (QName[])((ImmutableSet)exprs.stream().map(expr -> {
                    IfFeatureExpr ifFeatureExpr = expr;
                    Objects.requireNonNull(ifFeatureExpr);
                    IfFeatureExpr selector0$temp = ifFeatureExpr;
                    int index$1 = 0;
                    Single single = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Single.class, AbstractArray.class}, (Object)selector0$temp, index$1)) {
                        default -> throw new MatchException(null, null);
                        case 0 -> (Single)selector0$temp;
                        case 1 -> {
                            AbstractArray array = (AbstractArray)selector0$temp;
                            throw new VerifyException("Unexpected expression " + String.valueOf(array));
                        }
                    };
                    return single.qname;
                }).collect(ImmutableSet.toImmutableSet())).toArray((Object[])new QName[0]);
                if (positive) {
                    yield allPresent.apply(qnames);
                }
                yield allAbsent.apply(qnames);
            }
        };
    }

    private static final class Present
    extends Single {
        Present(QName qname) {
            super(qname);
        }

        @Override
        public IfFeatureExpr negate() {
            return new Absent(this.qname);
        }

        @Override
        public boolean test(FeatureSet supportedFeatures) {
            return supportedFeatures.contains(this.qname);
        }

        @Override
        public String toString() {
            return "\"" + String.valueOf(this.qname) + "\"";
        }
    }

    private static final class Absent
    extends Single {
        Absent(QName qname) {
            super(qname);
        }

        @Override
        public IfFeatureExpr negate() {
            return Absent.isPresent(this.qname);
        }

        @Override
        public boolean test(FeatureSet supportedFeatures) {
            return !supportedFeatures.contains(this.qname);
        }

        @Override
        public String toString() {
            return "not \"" + String.valueOf(this.qname) + "\"";
        }
    }

    private static abstract sealed class AbstractArray<T>
    extends IfFeatureExpr
    permits Complex, Compound {
        final T[] array;

        AbstractArray(T[] array) {
            this.array = Objects.requireNonNull(array);
            Verify.verify((array.length > 1 ? 1 : 0) != 0);
        }

        @Override
        public final int hashCode() {
            return Arrays.hashCode(this.array);
        }

        @Override
        public final boolean equals(Object obj) {
            return this == obj || this.getClass().isInstance(obj) && Arrays.deepEquals(this.array, ((AbstractArray)obj).array);
        }

        abstract String infix();
    }

    private static abstract sealed class Complex
    extends AbstractArray<IfFeatureExpr>
    permits AllExprs, AnyExpr {
        Complex(IfFeatureExpr[] array) {
            super(array);
        }

        @Override
        public final Set<QName> getReferencedFeatures() {
            HashSet<QName> ret = new HashSet<QName>();
            this.addQNames(ret);
            return ret;
        }

        @Override
        final void addQNames(Set<QName> set) {
            for (IfFeatureExpr expr : (IfFeatureExpr[])this.array) {
                expr.addQNames(set);
            }
        }

        final IfFeatureExpr[] negateExprs() {
            IfFeatureExpr[] ret = new IfFeatureExpr[((IfFeatureExpr[])this.array).length];
            for (int i = 0; i < ((IfFeatureExpr[])this.array).length; ++i) {
                ret[i] = (IfFeatureExpr)Verify.verifyNotNull((Object)((IfFeatureExpr[])this.array)[i].negate());
            }
            return ret;
        }

        @Override
        public final String toString() {
            StringBuilder sb = new StringBuilder("(").append(((IfFeatureExpr[])this.array)[0]);
            String sep = this.infix();
            for (int i = 1; i < ((IfFeatureExpr[])this.array).length; ++i) {
                sb.append(sep).append(((IfFeatureExpr[])this.array)[i]);
            }
            return sb.append(')').toString();
        }
    }

    private static abstract sealed class Single
    extends IfFeatureExpr
    permits Absent, Present {
        final @NonNull QName qname;

        Single(QName qname) {
            this.qname = Objects.requireNonNull(qname);
        }

        public final ImmutableSet<QName> getReferencedFeatures() {
            return ImmutableSet.of((Object)this.qname);
        }

        @Override
        public final int hashCode() {
            return this.qname.hashCode();
        }

        @Override
        final void addQNames(Set<QName> set) {
            set.add(this.qname);
        }

        @Override
        public final boolean equals(Object obj) {
            return this == obj || this.getClass().isInstance(obj) && this.qname.equals((Object)((Single)obj).qname);
        }
    }

    private static final class NotAny
    extends AbstractAny {
        NotAny(QName[] qnames) {
            super(qnames);
        }

        @Override
        public IfFeatureExpr negate() {
            return new Any((QName[])this.array);
        }

        @Override
        boolean negated() {
            return true;
        }
    }

    private static final class Any
    extends AbstractAny {
        Any(QName[] array) {
            super(array);
        }

        @Override
        public IfFeatureExpr negate() {
            return new NotAny((QName[])this.array);
        }

        @Override
        boolean negated() {
            return false;
        }
    }

    private static abstract sealed class AbstractAny
    extends Compound
    permits Any, NotAny {
        AbstractAny(QName[] qnames) {
            super(qnames);
        }

        @Override
        public final boolean test(FeatureSet supportedFeatures) {
            for (QName qname : (QName[])this.array) {
                if (!supportedFeatures.contains(qname)) continue;
                return !this.negated();
            }
            return this.negated();
        }

        @Override
        final String infix() {
            return " or ";
        }
    }

    private static final class NotAll
    extends AbstractAll {
        NotAll(QName[] qnames) {
            super(qnames);
        }

        @Override
        public IfFeatureExpr negate() {
            return new All((QName[])this.array);
        }

        @Override
        boolean negated() {
            return true;
        }
    }

    private static final class All
    extends AbstractAll {
        All(QName[] qnames) {
            super(qnames);
        }

        @Override
        public IfFeatureExpr negate() {
            return new NotAll((QName[])this.array);
        }

        @Override
        boolean negated() {
            return false;
        }
    }

    private static abstract sealed class AbstractAll
    extends Compound
    permits All, NotAll {
        AbstractAll(QName[] qnames) {
            super(qnames);
        }

        @Override
        public final boolean test(FeatureSet supportedFeatures) {
            boolean neg = this.negated();
            for (QName qname : (QName[])this.array) {
                if (supportedFeatures.contains(qname) != neg) continue;
                return false;
            }
            return true;
        }

        @Override
        final String infix() {
            return " and ";
        }
    }

    private static final class AnyExpr
    extends Complex {
        AnyExpr(IfFeatureExpr[] exprs) {
            super(exprs);
        }

        @Override
        public IfFeatureExpr negate() {
            return new AllExprs(this.negateExprs());
        }

        @Override
        public boolean test(FeatureSet supportedFeatures) {
            for (IfFeatureExpr expr : (IfFeatureExpr[])this.array) {
                if (!expr.test(supportedFeatures)) continue;
                return true;
            }
            return false;
        }

        @Override
        String infix() {
            return " or ";
        }
    }

    private static final class AllExprs
    extends Complex {
        AllExprs(IfFeatureExpr[] exprs) {
            super(exprs);
        }

        @Override
        public IfFeatureExpr negate() {
            return new AnyExpr(this.negateExprs());
        }

        @Override
        public boolean test(FeatureSet supportedFeatures) {
            for (IfFeatureExpr expr : (IfFeatureExpr[])this.array) {
                if (expr.test(supportedFeatures)) continue;
                return false;
            }
            return true;
        }

        @Override
        String infix() {
            return " and ";
        }
    }

    private static abstract sealed class Compound
    extends AbstractArray<QName>
    permits AbstractAll, AbstractAny {
        Compound(QName[] qnames) {
            super(qnames);
        }

        public final ImmutableSet<QName> getReferencedFeatures() {
            return ImmutableSet.copyOf((Object[])((QName[])this.array));
        }

        @Override
        final void addQNames(Set<QName> set) {
            set.addAll(Arrays.asList((QName[])this.array));
        }

        @Override
        public final String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.negated()) {
                sb.append("not ");
            }
            sb.append("(\"").append(((QName[])this.array)[0]).append('\"');
            String sep = this.infix();
            for (int i = 1; i < ((QName[])this.array).length; ++i) {
                sb.append(sep).append('\"').append(((QName[])this.array)[i]).append('\"');
            }
            return sb.append(')').toString();
        }

        abstract boolean negated();
    }
}

