/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public abstract sealed class ValueRange {
    public static @NonNull ValueRange of(@NonNull Number value) {
        return new Singleton(value);
    }

    public static @NonNull ValueRange of(@NonNull Number lower, @NonNull Number upper) {
        return lower.equals(upper) ? ValueRange.of(lower) : new Range(lower, upper);
    }

    public abstract @NonNull Number lowerBound();

    public abstract @NonNull Number upperBound();

    public final int hashCode() {
        return Objects.hash(this.lowerBound(), this.upperBound());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ValueRange)) return false;
        ValueRange other = (ValueRange)obj;
        if (!this.lowerBound().equals(other.lowerBound())) return false;
        if (!this.upperBound().equals(other.upperBound())) return false;
        return true;
    }

    private static final class Singleton
    extends ValueRange {
        private final @NonNull Number value;

        Singleton(@NonNull Number value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public @NonNull Number lowerBound() {
            return this.value;
        }

        @Override
        public @NonNull Number upperBound() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    private static final class Range
    extends ValueRange {
        private final @NonNull Number lower;
        private final @NonNull Number upper;

        Range(Number lower, Number upper) {
            this.lower = Objects.requireNonNull(lower);
            this.upper = Objects.requireNonNull(upper);
        }

        @Override
        public @NonNull Number lowerBound() {
            return this.lower;
        }

        @Override
        public @NonNull Number upperBound() {
            return this.upper;
        }

        public String toString() {
            return String.valueOf(this.lower) + ".." + String.valueOf(this.upper);
        }
    }
}

