/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.repo;

import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.ir.IRArgument;
import org.opendaylight.yangtools.yang.ir.IRKeyword;
import org.opendaylight.yangtools.yang.ir.IRStatement;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDeclaration;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSourceReference;
import org.opendaylight.yangtools.yang.model.api.source.SourceDependency;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.spi.meta.StatementDeclarations;
import org.opendaylight.yangtools.yang.model.spi.source.SourceInfo;
import org.opendaylight.yangtools.yang.model.spi.source.YangIRSource;
import org.opendaylight.yangtools.yang.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.ArgumentContextUtils;
import org.opendaylight.yangtools.yang.parser.rfc7950.repo.YangStatementStreamSource;

public final class YangIRSourceInfoExtractor {
    private static final String BELONGS_TO = YangStmtMapping.BELONGS_TO.getStatementName().getLocalName();
    private static final String IMPORT = YangStmtMapping.IMPORT.getStatementName().getLocalName();
    private static final String INCLUDE = YangStmtMapping.INCLUDE.getStatementName().getLocalName();
    private static final String MODULE = YangStmtMapping.MODULE.getStatementName().getLocalName();
    private static final String NAMESPACE = YangStmtMapping.NAMESPACE.getStatementName().getLocalName();
    private static final String PREFIX = YangStmtMapping.PREFIX.getStatementName().getLocalName();
    private static final String REVISION = YangStmtMapping.REVISION.getStatementName().getLocalName();
    private static final String REVISION_DATE = YangStmtMapping.REVISION_DATE.getStatementName().getLocalName();
    private static final String SUBMODULE = YangStmtMapping.SUBMODULE.getStatementName().getLocalName();
    private static final String YANG_VERSION = YangStmtMapping.YANG_VERSION.getStatementName().getLocalName();

    private YangIRSourceInfoExtractor() {
    }

    public static @NonNull SourceInfo forIR(YangIRSource source) {
        return YangIRSourceInfoExtractor.forIR(source.statement(), source.sourceId());
    }

    public static @NonNull SourceInfo forIR(IRStatement rootStatement, SourceIdentifier sourceId) {
        IRKeyword keyword = rootStatement.keyword();
        if (!(keyword instanceof IRKeyword.Unqualified)) {
            throw new IllegalArgumentException("Invalid root statement " + String.valueOf(keyword));
        }
        String arg = keyword.identifier();
        if (MODULE.equals(arg)) {
            return YangIRSourceInfoExtractor.moduleForIR(rootStatement, sourceId);
        }
        if (SUBMODULE.equals(arg)) {
            return YangIRSourceInfoExtractor.submmoduleForIR(rootStatement, sourceId);
        }
        throw new IllegalArgumentException("Root of parsed AST must be either module or submodule");
    }

    public static SourceInfo forYangText(YangTextSource yangText) throws IOException, YangSyntaxErrorException {
        YangStatementStreamSource source = YangStatementStreamSource.create(yangText);
        return YangIRSourceInfoExtractor.forIR(source.rootStatement(), (SourceIdentifier)source.getIdentifier());
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SourceInfo.Module moduleForIR(IRStatement root, SourceIdentifier sourceId) {
        SourceInfo.Module.Builder builder = SourceInfo.Module.builder();
        YangIRSourceInfoExtractor.fill(builder, root, sourceId);
        return (SourceInfo.Module)builder.setNamespace(root.statements().stream().filter(stmt -> YangIRSourceInfoExtractor.isStatement(stmt, NAMESPACE)).findFirst().map(stmt -> YangIRSourceInfoExtractor.safeStringArgument(sourceId, stmt, "namespace argument")).map(XMLNamespace::of).orElseThrow(() -> new IllegalArgumentException("No namespace statement in " + String.valueOf(YangIRSourceInfoExtractor.refOf(sourceId, root))))).setPrefix(YangIRSourceInfoExtractor.extractPrefix(root, sourceId)).build();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SourceInfo.Submodule submmoduleForIR(IRStatement root, SourceIdentifier sourceId) {
        SourceInfo.Submodule.Builder builder = SourceInfo.Submodule.builder();
        YangIRSourceInfoExtractor.fill(builder, root, sourceId);
        return (SourceInfo.Submodule)builder.setBelongsTo(root.statements().stream().filter(stmt -> YangIRSourceInfoExtractor.isStatement(stmt, BELONGS_TO)).findFirst().map(stmt -> new SourceDependency.BelongsTo(UnresolvedQName.Unqualified.of((String)YangIRSourceInfoExtractor.safeStringArgument(sourceId, stmt, "belongs-to module name")), YangIRSourceInfoExtractor.extractPrefix(stmt, sourceId))).orElseThrow(() -> new IllegalArgumentException("No belongs-to statement in " + String.valueOf(YangIRSourceInfoExtractor.refOf(sourceId, root))))).build();
    }

    private static void fill(SourceInfo.Builder<?, ?> builder, IRStatement root, SourceIdentifier sourceId) {
        builder.setName(UnresolvedQName.Unqualified.of((String)YangIRSourceInfoExtractor.safeStringArgument(sourceId, root, "module/submodule argument")));
        root.statements().stream().filter(stmt -> YangIRSourceInfoExtractor.isStatement(stmt, YANG_VERSION)).findFirst().map(stmt -> YangIRSourceInfoExtractor.safeStringArgument(sourceId, stmt, "yang-version argument")).map(YangVersion::forString).ifPresent(arg_0 -> builder.setYangVersion(arg_0));
        root.statements().stream().filter(stmt -> YangIRSourceInfoExtractor.isStatement(stmt, REVISION)).map(stmt -> Revision.of((String)YangIRSourceInfoExtractor.safeStringArgument(sourceId, stmt, "revision argument"))).forEach(arg_0 -> builder.addRevision(arg_0));
        root.statements().stream().filter(stmt -> YangIRSourceInfoExtractor.isStatement(stmt, IMPORT)).map(stmt -> new SourceDependency.Import(UnresolvedQName.Unqualified.of((String)YangIRSourceInfoExtractor.safeStringArgument(sourceId, stmt, "import argument")), YangIRSourceInfoExtractor.extractPrefix(stmt, sourceId), YangIRSourceInfoExtractor.extractRevisionDate(stmt, sourceId))).forEach(arg_0 -> builder.addImport(arg_0));
        root.statements().stream().filter(stmt -> YangIRSourceInfoExtractor.isStatement(stmt, INCLUDE)).map(stmt -> new SourceDependency.Include(UnresolvedQName.Unqualified.of((String)YangIRSourceInfoExtractor.safeStringArgument(sourceId, stmt, "include argument")), YangIRSourceInfoExtractor.extractRevisionDate(stmt, sourceId))).forEach(arg_0 -> builder.addInclude(arg_0));
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull UnresolvedQName.Unqualified extractPrefix(IRStatement root, SourceIdentifier sourceId) {
        return root.statements().stream().filter(stmt -> YangIRSourceInfoExtractor.isStatement(stmt, PREFIX)).findFirst().map(stmt -> UnresolvedQName.Unqualified.of((String)YangIRSourceInfoExtractor.safeStringArgument(sourceId, stmt, "prefix argument"))).orElseThrow(() -> new IllegalArgumentException("No prefix statement in " + String.valueOf(YangIRSourceInfoExtractor.refOf(sourceId, root))));
    }

    private static @Nullable Revision extractRevisionDate(IRStatement root, SourceIdentifier sourceId) {
        return root.statements().stream().filter(stmt -> YangIRSourceInfoExtractor.isStatement(stmt, REVISION_DATE)).findFirst().map(stmt -> Revision.of((String)YangIRSourceInfoExtractor.safeStringArgument(sourceId, stmt, "revision date argument"))).orElse(null);
    }

    private static boolean isStatement(IRStatement stmt, String name) {
        IRKeyword.Unqualified keyword;
        IRKeyword iRKeyword = stmt.keyword();
        return iRKeyword instanceof IRKeyword.Unqualified && name.equals((keyword = (IRKeyword.Unqualified)iRKeyword).identifier());
    }

    private static @NonNull String safeStringArgument(SourceIdentifier source, IRStatement stmt, String desc) {
        StatementDeclaration.InText ref = YangIRSourceInfoExtractor.refOf(source, stmt);
        IRArgument arg = stmt.argument();
        if (arg == null) {
            throw new IllegalArgumentException("Missing " + desc + " at " + String.valueOf(ref));
        }
        return ArgumentContextUtils.rfc6020().stringFromStringContext(arg, (StatementSourceReference)ref);
    }

    private static StatementDeclaration.InText refOf(SourceIdentifier source, IRStatement stmt) {
        return StatementDeclarations.inText((String)source.name().getLocalName(), (int)stmt.startLine(), (int)(stmt.startColumn() + 1));
    }
}

