/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.meta;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.MinElementsEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.MinElementsStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractInternedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

public final class MinElementsStatementSupport
extends AbstractInternedStatementSupport<Integer, MinElementsStatement, MinElementsEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.MIN_ELEMENTS).build();

    public MinElementsStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)YangStmtMapping.MIN_ELEMENTS, StatementSupport.StatementPolicy.contextIndependent(), config, SUBSTATEMENT_VALIDATOR);
    }

    public Integer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new SourceException("Invalid min-elements argument", ctx, (Throwable)e);
        }
    }

    protected MinElementsStatement createDeclared(Integer argument, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createMinElements((Integer)argument, substatements);
    }

    protected MinElementsStatement attachDeclarationReference(MinElementsStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateMinElements((MinElementsStatement)stmt, (DeclarationReference)reference);
    }

    protected MinElementsStatement createEmptyDeclared(Integer argument) {
        return DeclaredStatements.createMinElements((Integer)argument);
    }

    protected MinElementsEffectiveStatement createEffective(MinElementsStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createMinElements((MinElementsStatement)declared, substatements);
    }

    protected MinElementsEffectiveStatement createEmptyEffective(MinElementsStatement declared) {
        return EffectiveStatements.createMinElements((MinElementsStatement)declared);
    }
}

