/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternExpression;
import org.opendaylight.yangtools.yang.model.api.stmt.PatternStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.ri.stmt.EffectiveStatements;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.pattern.RegexUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class PatternStatementSupport
extends AbstractStatementSupport<PatternExpression, PatternStatement, PatternEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.PATTERN).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.ERROR_APP_TAG).addOptional((StatementDefinition)YangStmtMapping.ERROR_MESSAGE).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.PATTERN).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.ERROR_APP_TAG).addOptional((StatementDefinition)YangStmtMapping.ERROR_MESSAGE).addOptional((StatementDefinition)YangStmtMapping.MODIFIER).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).build();

    private PatternStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.PATTERN, StatementSupport.StatementPolicy.contextIndependent(), config, validator);
    }

    public static @NonNull PatternStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new PatternStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull PatternStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new PatternStatementSupport(config, RFC7950_VALIDATOR);
    }

    public PatternExpression parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        String pattern = RegexUtils.getJavaRegexFromXSD(value);
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new SourceException(ctx, (Throwable)e, "Pattern \"%s\" failed to compile", new Object[]{pattern});
        }
        return PatternExpression.of((String)value, (String)pattern).intern();
    }

    protected PatternStatement createDeclared(BoundStmtCtx<PatternExpression> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return DeclaredStatements.createPattern((PatternExpression)((PatternExpression)ctx.getArgument()), substatements);
    }

    protected PatternStatement attachDeclarationReference(PatternStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decoratePattern((PatternStatement)stmt, (DeclarationReference)reference);
    }

    protected PatternEffectiveStatement createEffective(EffectiveStmtCtx.Current<PatternExpression, PatternStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return EffectiveStatements.createPattern((PatternStatement)((PatternStatement)stmt.declared()), substatements);
    }
}

