/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.submodule;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.BelongsToStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SubmoduleStatement;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatementDecorators;
import org.opendaylight.yangtools.yang.model.ri.stmt.DeclaredStatements;
import org.opendaylight.yangtools.yang.model.spi.meta.SubstatementIndexingException;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.submodule.SubmoduleEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.spi.ParserNamespaces;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractUnqualifiedStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.CommonStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class SubmoduleStatementSupport
extends AbstractUnqualifiedStatementSupport<SubmoduleStatement, SubmoduleEffectiveStatement> {
    private static final SubstatementValidator RFC6020_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.SUBMODULE).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.AUGMENT).addMandatory((StatementDefinition)YangStmtMapping.BELONGS_TO).addAny((StatementDefinition)YangStmtMapping.CHOICE).addOptional((StatementDefinition)YangStmtMapping.CONTACT).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.DEVIATION).addAny((StatementDefinition)YangStmtMapping.EXTENSION).addAny((StatementDefinition)YangStmtMapping.FEATURE).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IDENTITY).addAny((StatementDefinition)YangStmtMapping.IMPORT).addAny((StatementDefinition)YangStmtMapping.INCLUDE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.NOTIFICATION).addOptional((StatementDefinition)YangStmtMapping.ORGANIZATION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addAny((StatementDefinition)YangStmtMapping.REVISION).addAny((StatementDefinition)YangStmtMapping.RPC).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).addOptional((StatementDefinition)YangStmtMapping.YANG_VERSION).build();
    private static final SubstatementValidator RFC7950_VALIDATOR = SubstatementValidator.builder((StatementDefinition)YangStmtMapping.SUBMODULE).addAny((StatementDefinition)YangStmtMapping.ANYDATA).addAny((StatementDefinition)YangStmtMapping.ANYXML).addAny((StatementDefinition)YangStmtMapping.AUGMENT).addMandatory((StatementDefinition)YangStmtMapping.BELONGS_TO).addAny((StatementDefinition)YangStmtMapping.CHOICE).addOptional((StatementDefinition)YangStmtMapping.CONTACT).addAny((StatementDefinition)YangStmtMapping.CONTAINER).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addAny((StatementDefinition)YangStmtMapping.DEVIATION).addAny((StatementDefinition)YangStmtMapping.EXTENSION).addAny((StatementDefinition)YangStmtMapping.FEATURE).addAny((StatementDefinition)YangStmtMapping.GROUPING).addAny((StatementDefinition)YangStmtMapping.IDENTITY).addAny((StatementDefinition)YangStmtMapping.IMPORT).addAny((StatementDefinition)YangStmtMapping.INCLUDE).addAny((StatementDefinition)YangStmtMapping.LEAF).addAny((StatementDefinition)YangStmtMapping.LEAF_LIST).addAny((StatementDefinition)YangStmtMapping.LIST).addAny((StatementDefinition)YangStmtMapping.NOTIFICATION).addOptional((StatementDefinition)YangStmtMapping.ORGANIZATION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addAny((StatementDefinition)YangStmtMapping.REVISION).addAny((StatementDefinition)YangStmtMapping.RPC).addAny((StatementDefinition)YangStmtMapping.TYPEDEF).addAny((StatementDefinition)YangStmtMapping.USES).addOptional((StatementDefinition)YangStmtMapping.YANG_VERSION).build();

    private SubmoduleStatementSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.SUBMODULE, StatementSupport.StatementPolicy.reject(), config, validator);
    }

    public static @NonNull SubmoduleStatementSupport rfc6020Instance(YangParserConfiguration config) {
        return new SubmoduleStatementSupport(config, RFC6020_VALIDATOR);
    }

    public static @NonNull SubmoduleStatementSupport rfc7950Instance(YangParserConfiguration config) {
        return new SubmoduleStatementSupport(config, RFC7950_VALIDATOR);
    }

    public void onPreLinkageDeclared(StmtContext.Mutable<UnresolvedQName.Unqualified, SubmoduleStatement, SubmoduleEffectiveStatement> stmt) {
        stmt.setRootIdentifier(new SourceIdentifier((UnresolvedQName.Unqualified)stmt.getArgument(), (Revision)StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements()).orElse(null)));
    }

    public void onLinkageDeclared(StmtContext.Mutable<UnresolvedQName.Unqualified, SubmoduleStatement, SubmoduleEffectiveStatement> stmt) {
        SourceIdentifier submoduleIdentifier = new SourceIdentifier((UnresolvedQName.Unqualified)stmt.getArgument(), (Revision)StmtContextUtils.getLatestRevision((Iterable)stmt.declaredSubstatements()).orElse(null));
        StmtContext possibleDuplicateSubmodule = (StmtContext)stmt.namespaceItem(ParserNamespaces.SUBMODULE, (Object)submoduleIdentifier);
        if (possibleDuplicateSubmodule != null && possibleDuplicateSubmodule != stmt) {
            throw new SourceException(stmt, "Submodule name collision: %s. At %s", new Object[]{stmt.rawArgument(), possibleDuplicateSubmodule.sourceReference()});
        }
        stmt.addToNs(ParserNamespaces.SUBMODULE, (Object)submoduleIdentifier, stmt);
        UnresolvedQName.Unqualified belongsToModuleName = (UnresolvedQName.Unqualified)StmtContextUtils.firstAttributeOf((Iterable)stmt.declaredSubstatements(), BelongsToStatement.class);
        StmtContext prefixSubStmtCtx = (StmtContext)SourceException.throwIfNull((Object)StmtContextUtils.findFirstDeclaredSubstatement(stmt, (int)0, (Class[])new Class[]{BelongsToStatement.class, PrefixStatement.class}), stmt, (String)"Prefix of belongsTo statement is missing in submodule [%s]", (Object[])new Object[]{stmt.rawArgument()});
        String prefix = prefixSubStmtCtx.rawArgument();
        stmt.addToNs(ParserNamespaces.BELONGSTO_PREFIX_TO_MODULE_NAME, (Object)prefix, (Object)belongsToModuleName);
    }

    protected SubmoduleStatement createDeclared(BoundStmtCtx<UnresolvedQName.Unqualified> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        if (substatements.isEmpty()) {
            throw SubmoduleStatementSupport.noBelongsTo(ctx);
        }
        return DeclaredStatements.createSubmodule((String)ctx.getRawArgument(), (UnresolvedQName.Unqualified)((UnresolvedQName.Unqualified)ctx.getArgument()), substatements);
    }

    protected SubmoduleStatement attachDeclarationReference(SubmoduleStatement stmt, DeclarationReference reference) {
        return DeclaredStatementDecorators.decorateSubmodule((SubmoduleStatement)stmt, (DeclarationReference)reference);
    }

    protected SubmoduleEffectiveStatement createEffective(EffectiveStmtCtx.Current<UnresolvedQName.Unqualified, SubmoduleStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        if (substatements.isEmpty()) {
            throw SubmoduleStatementSupport.noBelongsTo(stmt);
        }
        try {
            return new SubmoduleEffectiveStatementImpl(stmt, substatements);
        }
        catch (SubstatementIndexingException e) {
            throw new SourceException(e.getMessage(), stmt, (Throwable)e);
        }
    }

    private static SourceException noBelongsTo(CommonStmtCtx stmt) {
        return new SourceException("No belongs-to declared in submodule", stmt);
    }
}

