/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt.type;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.TypeStatement;
import org.opendaylight.yangtools.yang.model.api.type.TypeDefinitions;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

abstract class AbstractTypeSupport<T extends TypeStatement>
extends AbstractQNameStatementSupport<T, EffectiveStatement<QName, T>> {
    private static final ImmutableMap<String, QName> BUILTIN_TYPES = Maps.uniqueIndex(List.of(TypeDefinitions.BINARY, TypeDefinitions.BITS, TypeDefinitions.BOOLEAN, TypeDefinitions.DECIMAL64, TypeDefinitions.EMPTY, TypeDefinitions.ENUMERATION, TypeDefinitions.IDENTITYREF, TypeDefinitions.INSTANCE_IDENTIFIER, TypeDefinitions.INT8, TypeDefinitions.INT16, TypeDefinitions.INT32, TypeDefinitions.INT64, TypeDefinitions.LEAFREF, TypeDefinitions.STRING, TypeDefinitions.UINT8, TypeDefinitions.UINT16, TypeDefinitions.UINT32, TypeDefinitions.UINT64, TypeDefinitions.UNION), AbstractQName::getLocalName);

    AbstractTypeSupport(YangParserConfiguration config, SubstatementValidator validator) {
        super((StatementDefinition)YangStmtMapping.TYPE, StatementSupport.StatementPolicy.exactReplica(), config, Objects.requireNonNull(validator));
    }

    public final String internArgument(String rawArgument) {
        QName builtin = (QName)BUILTIN_TYPES.get((Object)rawArgument);
        return builtin != null ? builtin.getLocalName() : rawArgument;
    }

    public final QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        String rawArgument = ctx.getRawArgument();
        QName builtin = (QName)BUILTIN_TYPES.get((Object)rawArgument);
        return builtin != null ? builtin : StmtContextUtils.parseNodeIdentifier(ctx, (String)rawArgument);
    }
}

