/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6643.parser;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc6643.model.api.IetfYangSmiv2ExtensionsMapping;
import org.opendaylight.yangtools.rfc6643.model.api.ObjectIdentifier;
import org.opendaylight.yangtools.rfc6643.model.api.OidEffectiveStatement;
import org.opendaylight.yangtools.rfc6643.model.api.OidStatement;
import org.opendaylight.yangtools.rfc6643.parser.OidEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc6643.parser.OidStatementImpl;
import org.opendaylight.yangtools.rfc6643.parser.RefOidStatement;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class OidStatementSupport
extends AbstractStatementSupport<ObjectIdentifier, OidStatement, OidEffectiveStatement> {
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)IetfYangSmiv2ExtensionsMapping.OBJECT_ID).build();

    public OidStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)IetfYangSmiv2ExtensionsMapping.OBJECT_ID, StatementSupport.StatementPolicy.contextIndependent(), config, VALIDATOR);
    }

    public ObjectIdentifier parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return ObjectIdentifier.forString((String)value);
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx, (Throwable)e, "Invalid object identifier '%s'", new Object[]{value});
        }
    }

    protected OidStatement createDeclared(BoundStmtCtx<ObjectIdentifier> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return new OidStatementImpl((ObjectIdentifier)ctx.getArgument(), substatements);
    }

    protected OidStatement attachDeclarationReference(OidStatement stmt, DeclarationReference reference) {
        return new RefOidStatement(stmt, reference);
    }

    protected OidEffectiveStatement createEffective(EffectiveStmtCtx.Current<ObjectIdentifier, OidStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new OidEffectiveStatementImpl(stmt, substatements);
    }
}

