/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.DomainName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yangtools.binding.UnionTypeObject;
import org.opendaylight.yangtools.binding.lib.CodeHelpers;

public class Host
implements UnionTypeObject,
Serializable {
    private static final long serialVersionUID = -2403943164556299989L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.)$");
    private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
    private static final String regexes = "((([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.)*([a-zA-Z0-9_]([a-zA-Z0-9\\-_]){0,61})?[a-zA-Z0-9]\\.?)|\\.";
    private final IpAddress _ipAddress;
    private final DomainName _domainName;

    public Host(IpAddress _ipAddress) {
        this._ipAddress = Objects.requireNonNull(_ipAddress);
        this._domainName = null;
    }

    public Host(DomainName _domainName) {
        this._ipAddress = null;
        this._domainName = Objects.requireNonNull(_domainName);
    }

    public Host(Host source) {
        this._ipAddress = source._ipAddress;
        this._domainName = source._domainName;
    }

    public String stringValue() {
        if (this._ipAddress != null) {
            return this._ipAddress.stringValue();
        }
        if (this._domainName != null) {
            return this._domainName.getValue().toString();
        }
        throw new IllegalStateException("No value assigned");
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public DomainName getDomainName() {
        return this._domainName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._ipAddress);
        result = 31 * result + Objects.hashCode(this._domainName);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Host)) return false;
        Host other = (Host)obj;
        if (!Objects.equals(this._ipAddress, other._ipAddress)) return false;
        if (!Objects.equals(this._domainName, other._domainName)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Host.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"ipAddress", (Object)this._ipAddress);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"domainName", (Object)this._domainName);
        return helper.toString();
    }
}

